#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <asm/types.h>
#include <pthread.h>

#include "gsc16ao4mf_ioctl.h"
#include "kbhit.h"

char driver_name[80]="/dev/gsc_16ao4mf\0";

#define WORDS_TO_SEND 1024

char name[80];
volatile int done;
int shutdown;

/* text names to describe each type of board supported. */
char *boards_supported[] = {
    "GSC16AO4MF",
    NULL 
};

/* number of channels for each board supported. */

int channels[] = {
    1,
    
};

int channelIndex[MAX_CHANNELS];
int channelActive[MAX_CHANNELS];

int pass[MAX_CHANNELS];

void * channelthread(void *arg)
{
    struct register_params rw_q;
    unsigned long buffer[32768], total, count[16];
    int fd, res, i, print, nread;
    int board_type;
    unsigned long param;
    int channel;
    char localName[80];
    char channelString[80];

    strcpy(localName,driver_name);

    channel =  *(int*)arg;
    printf("about to open channel %d\n",channel);

    sprintf(channelString,"%d\0",channel);
    strcat(localName,channelString);
    printf("about to open %s\n",localName);

    fd = open(localName, O_RDWR);
    if (fd < 0) {
        printf("%s: can not open device %s\n", name, driver_name);
        return ;
    }

    res = ioctl(fd, (unsigned long)IOCTL_GET_DEVICE_TYPE, &board_type);
    if (res < 0) {
        printf("%s: ioctl IOCTL_GET_DEVICE_TYPE failed\n", name);
        goto out;
    }
    printf("open OK - board type: %s channels: %d\n", boards_supported[board_type],channels[board_type]);

    rw_q.eRegister = 0x0;
    rw_q.ulValue = 0x2000;
    res = ioctl(fd, (unsigned long)IOCTL_READ_REGISTER, &rw_q);
    if (res < 0) {
        printf("%s: ioctl IOCTL_READ_REGISTER failed\n", name);
        goto out;
    }

    pass[channel]=0;
    printf("before reset: BCR is 0x%lx\n", rw_q.ulValue);

    res = ioctl(fd, IOCTL_INIT_BOARD, NULL);
    if (res < 0) {
        printf("%s: ioctl IOCTL_INIT_BOARD failed\n", name);
        goto out;
    }

    if (res < 0) {
        printf("%s: ioctl IOCTL_INIT_BOARD failed\n", name);
        goto out;
    }
    printf("board init OK %d\n",i);

    rw_q.eRegister = BOARD_CTRL_REG;
    res = ioctl(fd, IOCTL_READ_REGISTER, &rw_q);
    if (res < 0) {
        printf("%s: ioctl IOCTL_READ_REGISTER failed\n", name);
        goto out;
    }
    printf("after reset: BCR is 0x%lx\n", rw_q.ulValue);

    res = ioctl(fd, IOCTL_AUTOCALIBRATE, NULL);
    if (res < 0) {
        printf("%s: ioctl IOCTL_AUTOCALIBRATE failed %d\n", name,i);
        goto out;
    }
    printf("auto calibration OK\n");

    // read auto calibration values - this is a reserved register.

    rw_q.eRegister = 0x14/4;
    res = ioctl(fd, IOCTL_READ_REGISTER, &rw_q);
    if (res < 0) {
        printf("%s: ioctl IOCTL_READ_REGISTER failed\n", name);
        goto out;
    }
    printf("after reset: Auto calibration values is 0x%lx\n", rw_q.ulValue);

    //   set clock.

    param = 10000*channel+5*channel;
    res = ioctl(fd, (unsigned long)IOCTL_PROGRAM_RATE_GEN, &param);
    if (res < 0) {
        printf("%s: ioctl IOCTL_PROGRAM_RATE_GEN failed\n", name);
        goto out;
    }

    // set the channel timeout

    param = 15; // seconds
    res = ioctl(fd, (unsigned long)IOCTL_SET_TIMEOUT, &param);
    if (res < 0) {
        printf("%s: ioctl IOCTL_SET_TIMEOUT failed\n", name);
        goto out;
    }

    //   two's comp data format.

    param = TWOS_COMP;
    res = ioctl(fd, (unsigned long)IOCTL_SELECT_DATA_FORMAT, &param);
    if (res < 0) {
        printf("%s: ioctl IOCTL_SELECT_DATA_FORMAT failed\n", name);
        goto out;
    }

    // simultaneous clocking.

    param = SIMULTANEOUS;
    res = ioctl(fd, (unsigned long)IOCTL_SELECT_OUT_CLKING_MODE, &param);
    if (res < 0) {
        printf("%s: ioctl IOCTL_SELECT_OUT_CLKING_MODE failed\n", name);
        goto out;
    }

    //   continuous or burst output.

    param = CONT_MODE;
    //param = BURST_MODE;
    res = ioctl(fd, (unsigned long)IOCTL_SELECT_SAMPLING_MODE, &param);
    if (res < 0) {
        printf("%s: ioctl IOCTL_SELECT_SAMPLING_MODE failed\n", name);
        goto out;
    }

    //   internal clock.

    param = INTERNAL;
    res = ioctl(fd, (unsigned long)IOCTL_SELECT_CLK_SOURCE, &param);
    if (res < 0) {
        printf("%s: ioctl IOCTL_SELECT_CLK_SOURCE failed\n", name);
        goto out;
    }

    // use the adjustable clock

    param=100; // 19.131 MHz, per hardware manual
    res = ioctl(fd, (unsigned long)IOCTL_SET_ADJUSTABLE_CLOCK, &param); 
    if (res < 0) {
        printf("%s: ioctl IOCTL_SET_ADJUSTABLE_CLOCK failed\n", name);
        goto out;
    }

    param=ICS_DIVIDED; // select the divided master/adjustable clock
    res = ioctl(fd, (unsigned long)IOCTL_SELECT_INTERNAL_CLOCK_SRC, &param); 
    if (res < 0) {
        printf("%s: ioctl IOCTL_SELECT_INTERNAL_CLOCK_SRC failed\n", name);
        goto out;
    }

    param=TRUE; // enable using the adjustable clock
    res = ioctl(fd, (unsigned long)IOCTL_ENABLE_ADJUSTABLE_CLOCK, &param); 
    if (res < 0) {
        printf("%s: ioctl IOCTL_ENABLE_ADJUSTABLE_CLOCK failed\n", name);
        goto out;
    }

    //   enable clock.

    res = ioctl(fd, (unsigned long)IOCTL_ENABLE_CLK); 
    if (res < 0) {
        printf("%s: ioctl IOCTL_ENABLE_CLK failed\n", name);
        goto out;
    }

    //   create a buffer of data.

    for (i=0;i<WORDS_TO_SEND;i++)
    {
        buffer[i]=i*0x100;
    }

    // the end of buffer flag really only means anything if
    // the output buffer is set to 'closed,' which this 
    // program does not do, so this just demonstrates how to
    // set the flag.

    buffer[WORDS_TO_SEND]|=ODB_EOF_FLAG; // mark end of buffer.

    // write a buffer with PIO.  The driver 'knows' to wait for
    // the buffer to be ready.

    printf("before PIO write\n");

    param = DMA_DISABLE;
    res = ioctl(fd, (unsigned long)IOCTL_SET_DMA_MODE, &param);
    if (res < 0) {
        printf("%s: ioctl IOCTL_WRITE_MODE_CONFIG failed\n", name);
        goto out;
    }

    for(i=0;i<5;i++)
    {
        res = write(fd, buffer, WORDS_TO_SEND*4);
        if (res < 0){
            printf("\nwrite error -> after write...res = %d\n",res);
            done=TRUE;
            goto out;
        }
    }

    printf("after PIO write\n");

    // write buffers with DMA.  The driver 'knows' to wait for 
    // the buffer ready.

// 6/6/05 - DMA not ready yet - ESH
/*
	param = DMA_ENABLE;
    res = ioctl(fd, (unsigned long)IOCTL_SET_DMA_MODE, &param);
    if (res < 0) {
        printf("%s: ioctl IOCTL_WRITE_MODE_CONFIG failed\n", name);
        goto out;
    }
*/
//    printf("before DMA write channel %d\n",channel);

    while(!done)
    {
        pass[channel]++;
        res = write(fd, buffer, WORDS_TO_SEND*4);
        if (res < 0){
            printf("\n read error -> after write...res = %d channel %d\n",res,channel);
            done=TRUE; // abort test if error.
            goto out;
    }

//        printf(">>>>>>>End of pass %d  Press any key to stop...\r",pass);
    }
   
out:
    //   disable clock.


    printf("\n");
    res = ioctl(fd, (unsigned long)IOCTL_DISABLE_CLK);
    if (res < 0) {
        printf("%s: ioctl IOCTL_DISABLE_CLK failed\n", name);
    }
    channelActive[channel]=FALSE;
    close(fd);
}

//////////////////////////////////////////////////////////////////////////
int main(int argc, char *argv[])
{
    pthread_t channelThread[MAX_CHANNELS];
    int i;
    int passes;
    time_t now, start, begin;

    strcpy(name,argv[0]);
    if (argc < 2) {
        printf("%s: missing argument\nusage: testapp [0|1|2|...]\n", name);
        return (1);
    }
    done=FALSE;
    init_keyboard();
    begin=time(NULL);

    for (i=0;i<MAX_CHANNELS;i++)
    {
        channelIndex[i]=i;
        channelActive[i]=TRUE;
        printf("starting channel %d\n",i);
        pthread_create(&channelThread[i],NULL,&channelthread,(void *)&channelIndex[i]);
    }

    printf("\n\n");
    while(!kbhit() && !done)
    {
        sleep(1);
        printf("elapsed: %d >>>>>>>Total passes:  ",time(NULL)-begin);
        for (i=0;i<MAX_CHANNELS;i++)
        {
            printf(" [%d]-%d ",i,pass[i]);
        }
        printf(" done: %d ",done);
        printf("\r");
       // done=TRUE;
    }
    done=TRUE;
    passes=0;

    printf("\nWaiting for shutdown...\n");
    while (passes<10) {
        sleep(1);
        shutdown=TRUE;
        for (i=0;i<MAX_CHANNELS;i++)
        {
            if (channelActive[i]) {
                shutdown=FALSE;
            }
        }
        if (shutdown) goto out;
    }
out:
    close_keyboard();
    printf("\n");
    return 0;
}
