/***
***  read.c
***
***  General description of this file:
***     Device driver source code for General Standards gsc16aio168
***     family of Delta-Sigma A/D board. This file is part of the Linux
***     driver source distribution for this board.
***
***     This file is not necessary to compile application programs, therefore
***     should NOT be included in binary only driver distributions.
***
***  Copyrights (c):
***     General Standards Corporation (GSC), Feb 2004
***
***  Author:
***     Evan Hillan (evan@generalstandards.com)
***
***  Support:
***     Primary support for this driver is provided by GSC. 
***
***  Platform (tested on, may work with others):
***     Linux, kernel version 2.4.18+, Red Hat distribution, Intel hardware.
***
***/

//////////////////////////////////////////////////////////////////////////
// set the following flag to trace interrupt debug messages.
#ifdef DEBUG
//#define TRACE_READ TRUE
#endif

#include <linux/module.h>
#include <linux/fs.h>
#include <linux/vmalloc.h>
#include <linux/pci.h>
#include <linux/mm.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/timer.h>
#include <linux/ioctl.h>

#include <asm/io.h>
#include <asm/system.h>
#include <asm/uaccess.h>

#include "sysdep.h"
#include "gsc16ao4mf_ioctl.h"
#include "internals.h"

#include "plx_regs.h"

#define DMA_DEMAND_MODE 100 /* not used in this driver, here for a placeholder */

/************************************************************************/
/* read operation: easy -- just return an error                        */
/************************************************************************/
int device_read(struct file *fp, char *buf, size_t size, loff_t * lt)
{
    return (-EPERM);
}
