/***
***  gsc16aio168_main.c
***
***  General description of this file:
***     Device driver source code for General Standards gsc16aio168
***     family of Delta-Sigma A/D board. This file is part of the Linux
***     driver source distribution for this board.
***
***     This file is not necessary to compile application programs, therefore
***     should NOT be included in binary only driver distributions.
***
***  Copyrights (c):
***     General Standards Corporation (GSC), 2005
***
***  Author:
***     Evan Hillan (evan@generalstandards.com)
***
***  Support:
***     Primary support for this driver is provided by GSC. 
***
***  Platform (tested on, may work with others):
***     Linux, kernel version 2.4.18+, Red Hat distribution, Intel hardware.
***
***/

//////////////////////////////////////////////////////////////////////////
// set the following flag to trace interrupt debug messages.
#ifdef DEBUG
//#define TRACE_INTS TRUE
#endif

#define __NO_VERSION__
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/vmalloc.h>
#include <linux/pci.h>
#include <linux/mm.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/timer.h>
#include <linux/ioctl.h>

#include <asm/io.h>
#include <asm/system.h>
#include <asm/uaccess.h>

#include "sysdep.h"
#include "gsc16ao4mf_ioctl.h"
#include "internals.h"

#include "plx_regs.h"
MODULE_LICENSE("GPL");

#define DEFAULT_TIMEOUT MSECS_TO_SLEEP(5000)

struct board_entry boards_supported[] = {
    {GSC_SUBVENDOR,0x3064,"GSC-16AO4MF",GSC_16AO4MF},
    {0,0,"NULL",0},               /* null terminated list.... */
};

/* Driver Version */
const char device_version[] = "$Date: " __DATE__ " " __TIME__ " $";

/* module load/unload functions */
int init_module(void);
void cleanup_module(void);

/* local functions */
int device_write(struct file *, const char *, size_t, loff_t *);
int device_read(struct file *, char *, size_t, loff_t *);
int device_open(struct inode *, struct file *);
int device_close(struct inode *, struct file *);

int device_read_buffer(struct device_board *device, char *buf, int nsamp, int noblock);

int device_read_dma(struct device_board *device, int nsamples);

#ifdef DEBUG
    u32 int_other_count[MAX_BOARDS];
    u32 int_count[MAX_BOARDS];
    u32 dma_count[MAX_BOARDS];
    u32 channel_irq[MAX_BOARDS];
    u32 channel_expected[MAX_BOARDS];
    int board_type[MAX_BOARDS];
    void * context[MAX_BOARDS];
#endif

//#ifdef DEBUG
/************************************************************************/
/* regdump - debug only                                                 */
/************************************************************************/
void regdump(struct device_board *device,char * label)
{
    int q;

//    printk("Device: %p intermediate buffer: %p\n",device,device->dma_data[TX].intermediateBuffer);

    for (q=0;q<=LAST_LOCAL_REGISTER;q++)
    {
        printk(KERN_INFO GSC_NAME "(%d - %s): register %.2d (addr %.2X) value: %.8x\n", device->minor, label, q, q*4,readlocal(device,q));
    }
    printk(KERN_INFO GSC_NAME "(%d - %s)                 IntCntrlStat: %.8X \n", device->minor, label,readl(IntCntrlStat(device->pHardware)));
//    printk(KERN_INFO GSC_NAME "(%d - %s)                   DMA status: %.8X \n", device->minor, label,readl(DMACmdStatus(device->pHardware)));
//    printk(KERN_INFO GSC_NAME "(%d - %s)                     DMA Mode: %.8X \n", device->minor, label,readl(DMAMode0(device->pHardware)));
/*
    if (NULL != device->dma_data[TX].intermediateBuffer)
    {
        for (q=0;q<=12;q++)
        {
            printk("%.8X ",device->dma_data[TX].intermediateBuffer[q]);
        }
    }
    */
    printk("\n----------------------------------\n");

}
//#endif

/************************************************************************/
/* timeout_handler                                                      */
/************************************************************************/
void timeout_handler(unsigned long ptr)
{
    struct device_board *device = (struct device_board *) ptr;

    int i;

#ifdef TRACE_INTS
    writel(0xAaaaaaaa, (Mailbox0(device->pHardware)));
    writel((unsigned long)device, (Mailbox0(device->pHardware)));
#endif
    regdump(device,"timeout " );
    device->timeout=TRUE;

    // wake up whatever was waiting.
    printk(KERN_ERR GSC_NAME " timeout -> plx int %.8X board control %.8X DMA status %.8X \n",
        readl(IntCntrlStat(device->pHardware)), readlocal(device,BOARD_CTRL_REG),
        readl(DMACmdStatus(device->pHardware)));
    printk(KERN_ERR GSC_NAME " DMA Mode %.8X\n",readl(DMAMode0(device->pHardware)));

    // wake up whatever was waiting before the timeout
    // wake up whatever was waiting.
    printk(KERN_ERR GSC_NAME " timeout -> plx int %.8X board control %.8X DMA status %.8X \n",
        readl(IntCntrlStat(device->pHardware)), readlocal(device,BOARD_CTRL_REG),
        readl(DMACmdStatus(device->pHardware)));
    printk(KERN_ERR GSC_NAME " DMA Mode %.8X\n",readl(DMAMode0(device->pHardware)));
    printk(KERN_ERR GSC_NAME " Firm rev %.8X DMA event # %d\n",readlocal(device,0x3c/4),EVENT_DMA_PENDING);


    for(i=0;i<EVENT_LAST_IRQ_EVENT;i++)
    {
        printk(KERN_ERR GSC_NAME "(%d): timeout - event %d status %d\n", device->minor, i,atomic_read(&device->irq_event_pending[i]));
        if (atomic_read(&device->irq_event_pending[i]))
        {
            printk(KERN_ERR GSC_NAME "(%d): ERROR - event %d timeout\n", device->minor, i);
            atomic_set(&device->irq_event_pending[i],FALSE);
            wake_up_interruptible(device->event_queue_waiting[i]);
        }
    }

    printk(KERN_ERR GSC_NAME "(%d): End timeout handler\n", device->minor);
    return;
}

/*************************************************/
#define CLEAR_SPURIOUS_PLX(regval,mask, desc)  { \
    if (regval & mask) \
{ \
    writel((regval & ~mask), IntCntrlStat(device->pHardware)); \
} \
}
/*printk(KERN_INFO GSC_NAME "(%d): Unexpected interrupt %s %.8lX %.8X %.8X\n",device->minor,desc, regval,mask,~mask); \*/

/************************************************************************/
/* Interrupt handler                                                    */
/************************************************************************/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
irqreturn_t device_interrupt(int irq, void *dev_id, struct pt_regs *regs)
#else
void device_interrupt(int irq, void *dev_id, struct pt_regs *regs)
#endif
{
    struct device_hardware *pHw = (struct device_hardware *)dev_id;
    struct device_board *device; 
    unsigned long plxreg;
    unsigned long localreg,bcr_reg;
    int handled=FALSE;
    int local_irq;
    int channelIndex;
  //  static int passes;

#ifdef TRACE_INTS
    printk(KERN_INFO GSC_NAME ": Interrupt()+++++\n");
#endif   
    // determine if the interrupt is from this board.

    plxreg = readl(IntCntrlStat(pHw));
    if ((plxreg & IRQ_PCI_ENABLE) ==0) { // not ours 
        //printk(KERN_INFO GSC_NAME " Interrupt not ours 1...\n");

#ifdef TRACE_INTS
        //int_other_count[device->board_index]++;
#endif
#ifdef TRACE_INTS
        writel(0x11111111, (Mailbox0(pHw)));
#endif
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
        return IRQ_NONE;
#else
        return;             
#endif
    }
#ifdef TRACE_INTS
        writel(0x10101010, (Mailbox0(pHw)));
#endif

	// deal with DMA

    device=pHw->channelData[0];
    localreg = readl(DMACmdStatus(device->pHardware));
    if ((localreg & DMA0_DONE)&&(localreg & CH0_DMA_ENABLE_MASK)) {
		
		// clear it
        
		writel((localreg | DMA0_CLR_INT), DMACmdStatus(device->pHardware));
        writel((DMA0_CLR_INT|DMA1_CLR_INT), DMACmdStatus(device->pHardware));
		
		// see which channel expected it.

	    for (channelIndex=0;channelIndex<MAX_CHANNELS;channelIndex++)
        {
            device=pHw->channelData[channelIndex];

            if (atomic_read(&device->irq_event_pending[EVENT_DMA_PENDING])) {
                printk(KERN_INFO GSC_NAME "(%d): IRQ Dma in progress...channel %d\n",device->minor,channelIndex);
                    handled = TRUE;
                    printk(KERN_INFO GSC_NAME "(%d): IRQ Dma done...channel %d\n",device->minor,channelIndex);
                // ack interrupt 
                // wake up process blocked in 'read()' 
                    atomic_set(&device->irq_event_pending[EVENT_DMA_PENDING],FALSE);
#ifdef TRACE_INTS
                    dma_count[device->board_index]++;
#endif
                    wake_up_interruptible(&device->dmawq);
                }
        }
        /*
        else    // check for and clear spurious DMA interrupts...
        {
            plxreg = readl(DMACmdStatus(device->pHardware));
            if (plxreg & DMA0_ENABLE) {
                // wipe out the DMA1 bits while here, better safe than sorry.
                printk(KERN_INFO GSC_NAME "(%d): Unexpected interrupt DMA0_ENABLE\n",device->minor); 
                writel((DMA0_CLR_INT|DMA1_CLR_INT), DMACmdStatus(device->pHardware)); 
            }
        }
        */
		if (!handled)
		{
			printk(KERN_INFO GSC_NAME "(%d): Unexpected interrupt DMA0_ENABLE\n",device->minor); 
		}
	} // if (localreg & DMA0_DONE)

	plxreg = readl(IntCntrlStat(pHw));
    if ((plxreg & IRQ_LOCAL_ACTIVE) ==0) { // not ours 
		//printk(KERN_INFO GSC_NAME " Interrupt not ours 2...\n");
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
        return IRQ_NONE;
#else
        return;             
#endif
	}
	// deal with local interrupt sources

	for (channelIndex=0;channelIndex<MAX_CHANNELS;channelIndex++)
    {
        device=pHw->channelData[channelIndex];
#ifdef TRACE_INTS    
       // printk(KERN_INFO GSC_NAME "(%d): Interrupt: checking channel %d, device %p\n", device->minor,channelIndex,device);
#endif
#ifdef TRACE_INTS
        writel(0x12121212, (Mailbox0(pHw)));
#endif
/*
        passes++;
            if (passes>10) {
                DisableIrqPlx(device);
                printk("bailing\n");
                return IRQ_HANDLED;
            }
*/

        bcr_reg = readlocal(device,BOARD_CTRL_REG);
        writelocal(device,bcr_reg&(~(BCR_INTERRUPT_REQUEST_FLAG)),BOARD_CTRL_REG);
#ifdef TRACE_INTS    
        printk(KERN_INFO GSC_NAME "(%d): checking channel %d, bcr %.8lX DMA pending %d low quarter pending %d\n", device->minor,channelIndex,bcr_reg,atomic_read(&device->irq_event_pending[EVENT_DMA_PENDING]),atomic_read(&device->irq_event_pending[EVENT_OUT_BUFFER_LOW_QUARTER]));
#endif

        // check for local interrupt

#ifdef TRACE_INTS
        writel(0x13131313, (Mailbox0(device->pHardware)));
#endif
        if (bcr_reg & BCR_INTERRUPT_REQUEST_FLAG) {
            writelocal(device,bcr_reg&(~(BCR_INTERRUPT_REQUEST_FLAG|BCR_IRQ_MASK)),BOARD_CTRL_REG);

            // see which kind of event is this.  The hardware is assumed to only have one
            // interrupt active at a time.
#ifdef TRACE_INTS
            int_count[device->board_index]++;
#endif
            local_irq=((bcr_reg&BCR_IRQ_MASK)>>BCR_IRQ_SHIFT) ; 

#ifdef TRACE_INTS
            printk(KERN_INFO GSC_NAME "(%d): local IRQ # %d channel %d\n", device->minor,local_irq,channelIndex);
#endif
            if (atomic_read(&device->irq_event_pending[local_irq])) {
#ifdef TRACE_INTS
                writel(0x14141414, (Mailbox0(device->pHardware)));
#endif
                atomic_set(&device->irq_event_pending[local_irq],FALSE);
                wake_up_interruptible(device->event_queue_waiting[local_irq]);
                handled = TRUE;
            }
            else
            {
#ifdef TRACE_INTS
                writel(0x15151515, (Mailbox0(device->pHardware)));
#endif
                DisableIrqLocalAll(device);
				device->pHardware->error=TRUE;
                printk(KERN_ERR GSC_NAME "(%d): disabled irq on device %p channel %d ********************************\n", device->minor, device,channelIndex);
            }
        }
    }

    if (!handled)
    {
#ifdef TRACE_INTS
        writel(0x16161616, (Mailbox0(device->pHardware)));
        plxreg = readl(IntCntrlStat(device->pHardware));
        bcr_reg = readlocal(device,BOARD_CTRL_REG);
#endif
		device->pHardware->error=TRUE;
        DisableIrqPlx(device);
        printk(KERN_ERR GSC_NAME "(%d): irq handler - interrupt not handled!*********************************************\n", device->minor);
    }
#ifdef TRACE_INTS
    //printk(KERN_INFO GSC_NAME "(%d): irq handler re-enable %p\n", device->minor,device);
#endif
    plxreg = readl(IntCntrlStat(device->pHardware));
#ifdef TRACE_INTS
    //bcr_reg = readlocal(device,BOARD_CTRL_REG);
    //printk(KERN_INFO GSC_NAME "(%d): irq handler re-enable PLX: %.8lx BCR: %.8lx\n", device->minor,plxreg,bcr_reg);
#endif
   // plxreg &= ~PCI_INT_ENABLE;
   // writel(plxreg, (IntCntrlStat(device->pHardware)));

    /*
    *   check every possible interrupt source, to ensure that the
    * current interrupt is turned off, expected or not.
    */

    // PLX interrupt-control registers.
    CLEAR_SPURIOUS_PLX(plxreg,IRQ_LOCAL_LSERR_ABORT, "IRQ_LOCAL_LSERR_ABORT*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_LOCAL_LSERR_ABORT, "IRQ_LOCAL_LSERR_ABORT*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_LOCAL_LSERR_OVERFLOW, "IRQ_LOCAL_LSERR_OVERFLOW*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_GENERATE_SERR, "IRQ_GENERATE_SERR*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_MAILBOX_ENABLE, "IRQ_MAILBOX_ENABLE*");
    //  CLEAR_SPURIOUS_PLX(plxreg, IRQ_PCI_ENABLE, "IRQ_PCI_ENABLE*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_PCI_DOORBELL_ENABLE, "IRQ_PCI_DOORBELL_ENABLE*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_ABORT_ENABLE, "IRQ_ABORT_ENABLE*");
    //  CLEAR_SPURIOUS_PLX(plxreg, IRQ_LOCAL_PCI_ENABLE, "IRQ_LOCAL_PCI_ENABLE*");
    //  CLEAR_SPURIOUS_PLX(plxreg, IRQ_LOCAL_ENABLE, "IRQ_LOCAL_ENABLE*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_LOCAL_DOORBELL_ENABLE, "IRQ_LOCAL_DOORBELL_ENABLE*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_DMA_1_ENABLE,"IRQ_DMA_1_ENABLE*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_LOCAL_DOORBELL_ACTIVE,"IRQ_LOCAL_DOORBELL_ACTIVE*");
    CLEAR_SPURIOUS_PLX(plxreg, IRQ_DMA_1_ACTIVE,"IRQ_DMA_1_ACTIVE*");
#ifdef TRACE_INTS
    printk(KERN_INFO GSC_NAME ": Interrupt handler exit-----\n");
#endif   

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
    return IRQ_HANDLED;
#else
    return;             
#endif

}
