//////////////////////////////////////////////////////////////////////////
// set the following flag to trace interrupt debug messages.
#ifdef DEBUG
#define TRACE_HARDWARE TRUE
#endif

#include <linux/module.h>
#include <linux/fs.h>
#include <linux/vmalloc.h>
#include <linux/pci.h>
#include <linux/mm.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/timer.h>
#include <linux/ioctl.h>

#include <asm/io.h>
#include <asm/system.h>
#include <asm/uaccess.h>

#include "sysdep.h"
#include "gsc16ao4mf_ioctl.h"
#include "internals.h"

#include "plx_regs.h"

/************************************************************************/
/*                                                                      */
/************************************************************************/
void DisableIrqPlx(struct device_board *device)
{
#ifdef DEBUG
        printk(KERN_INFO GSC_NAME " DisableIrqPlx\n");
#endif
    writel(readl(IntCntrlStat(device->pHardware)) & ~(IRQ_PCI_ENABLE | IRQ_DMA_0_ENABLE | IRQ_LOCAL_PCI_ENABLE), IntCntrlStat(device->pHardware));
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void EnableIrqPlxLocal(struct device_board *device)
{
	if (device->pHardware->error)
	{
		DisableIrqPlx(device);
#ifdef DEBUG
        printk(KERN_INFO GSC_NAME " EnableIrqPlxLocal error out\n");
#endif
		return;
	}
    writel(readl(IntCntrlStat(device->pHardware)) | IRQ_PCI_ENABLE | IRQ_LOCAL_PCI_ENABLE, IntCntrlStat(device->pHardware));
#ifdef DEBUG
    printk(KERN_INFO GSC_NAME " EnableIrqPlxLocal device ptr: %p hw: %p IntCntrlStat %.8X\n",device,device->pHardware,readl(IntCntrlStat(device->pHardware)));
#endif
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void EnableIrqPlxDMA(struct device_board *device)
{
	if (device->pHardware->error)
	{
		DisableIrqPlx(device);
#ifdef DEBUG
        printk(KERN_INFO GSC_NAME " EnableIrqPlxDMA error out\n");
#endif
		return;
	}
    writel(readl(IntCntrlStat(device->pHardware)) | IRQ_PCI_ENABLE | IRQ_DMA_0_ENABLE /*|PCI_INT_ENABLE*/, IntCntrlStat(device->pHardware));
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void DisableIrqLocalAll(struct device_board *device)
{
    u32 regval;
#ifdef DEBUG
    printk(KERN_INFO GSC_NAME " DisableIrqLocalAll device ptr: %p hw: %p\n",device,device->pHardware);
#endif
    //return;

    regval = readlocal(device,BOARD_CTRL_REG);
    regval &= (~(BCR_IRQ_MASK));
    writelocal(device,regval,BOARD_CTRL_REG);

    regval = readlocal(device,BOARD_CTRL_REG);
    regval &= (~(BCR_INTERRUPT_REQUEST_FLAG));
    writelocal(device,regval,BOARD_CTRL_REG);
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void EnableIrqLocal(struct device_board *device, u32 irq)
{
    u32 regval;

    regval = readlocal(device,BOARD_CTRL_REG);
    regval &= (~(BCR_IRQ_MASK));
    regval |= (irq << BCR_IRQ_SHIFT);
    writelocal(device,regval,BOARD_CTRL_REG);
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void DisableIrqLocal(struct device_board *device, u32 irq)
{
    u32 regval;

    regval = readlocal(device,BOARD_CTRL_REG);
    regval &= (~(BCR_IRQ_MASK));
    writelocal(device,regval,BOARD_CTRL_REG);
}

/************************************************************************/
/* writelocal                                                           */
/*                                                                      */
/* Write to the board local registers, whether the local registers      */
/* are in I/O space or memory space.                                    */
/*                                                                      */
/*                                                                      */
/************************************************************************/
void writelocal(struct device_board *device, unsigned value, unsigned address)
{
    if (device->pHardware->PciBar[2].IsIoMapped) /* i/o space */
    {
        //printk(KERN_INFO GSC_NAME "writelocal I/O space addr: %.8X value: %.8X.\n",address,value);
        outl(value, (unsigned) (device->pHardware->local_addr)+(channelOffset[device->channelIndex])+address*4);
    }
    else
    {
        //printk(KERN_INFO GSC_NAME "writelocal mem space addr: %.8X value: %.8X Channel: %d\n",address,value, channelOffset[device->channelIndex]);
        writel(value, device->pHardware->local_addr+address+(channelOffset[device->channelIndex]));
    }
};

/************************************************************************/
/* readlocal                                                            */
/*                                                                      */
/* Read from the board local registers, whether the local registers     */
/* are in I/O space or memory space.                                    */
/*                                                                      */
/*                                                                      */
/************************************************************************/
unsigned readlocal(struct device_board *device, unsigned address)
{
    if (device->pHardware->PciBar[2].IsIoMapped) /* i/o space */
    {
        //printk(KERN_INFO GSC_NAME "readlocal I/O space addr: %.8X \n",address);
        return inl((unsigned)(device->pHardware->local_addr)+(channelOffset[device->channelIndex])+address*4);
    }
    else
    {
        //printk(KERN_INFO GSC_NAME " readlocal mem space addr: %.8X channel %d actual: %p\n",address+(channelOffset[device->channelIndex]*4),device->channelIndex, device->pHardware->local_addr+address+(channelOffset[device->channelIndex]));
        return readl(device->pHardware->local_addr+address+(channelOffset[device->channelIndex]));
    }
    return 0;
};

