/***
*** gsc16ao4mf_ioctl.h 
***
***
***  General description of this file:
***     Device driver source code for General Standards 16AO family of 
***     16-bit analog output boards. This file is part of the Linux
***     driver source distribution for this board.
***     
***  Copyrights (c):
***     General Standards Corporation (GSC), 2003-2004
***
***  Author:
***     Evan Hillman (evan@generalstandards.com)
***
***  Support:
***     Primary support for this driver is provided by GSC. 
***
***  Platform (tested on, may work with others):
***     Linux, kernel version 2.4.x, Red Hat distribution, Intel hardware.
***/

#ifndef PCI12AO_IOCTL_H_INCLUDED
#define PCI12AO_IOCTL_H_INCLUDED

#ifndef TRUE
#define TRUE (1==1)
#endif
#ifndef FALSE
#define FALSE (!TRUE)
#endif

// total independent channels

#define MAX_CHANNELS 4

/*
 *  error codes.
 */
#define DEVICE_SUCCESS                         0
#define DEVICE_INVALID_PARAMETER               1
#define DEVICE_INVALID_BUFFER_SIZE             2
#define DEVICE_PIO_TIMEOUT                     3
#define DEVICE_DMA_TIMEOUT                     4
#define DEVICE_IOCTL_TIMEOUT                   5
#define DEVICE_OPERATION_CANCELLED             6
#define DEVICE_RESOURCE_ALLOCATION_ERROR       7
#define DEVICE_INVALID_REQUEST                 8
#define DEVICE_AUTOCAL_FAILED                  9
/*
 *  IOCTL defines
 */
#define IOCTL_AO                           's'

#define IOCTL_NO_COMMAND                _IO  (IOCTL_AO, 1)
#define IOCTL_READ_REGISTER             _IOWR(IOCTL_AO, 2,struct register_params)   
#define IOCTL_WRITE_REGISTER            _IOWR(IOCTL_AO, 3,struct register_params)
#define IOCTL_INIT_BOARD                _IO  (IOCTL_AO, 4)  
#define IOCTL_SET_DMA_MODE              _IOW (IOCTL_AO, 5, unsigned long)
#define IOCTL_GET_DEVICE_ERROR          _IOR (IOCTL_AO, 6, unsigned long)
#define IOCTL_AUTOCALIBRATE             _IOW (IOCTL_AO, 7, unsigned long)
#define IOCTL_PROGRAM_RATE_GEN          _IOW (IOCTL_AO, 8, unsigned long)
#define IOCTL_CHANNEL_ENABLE            _IOW (IOCTL_AO, 9, unsigned long)
#define IOCTL_SET_OUT_BUFFER_SIZE       _IOW (IOCTL_AO, 10,unsigned long)
#define IOCTL_GET_BUFFER_STATUS         _IOR (IOCTL_AO, 11,unsigned long)
#define IOCTL_ENABLE_CLK                _IO  (IOCTL_AO, 12)
#define IOCTL_DISABLE_CLK               _IO  (IOCTL_AO, 13)
#define IOCTL_SELECT_DATA_FORMAT        _IOW (IOCTL_AO, 14,unsigned long)
#define IOCTL_SELECT_SAMPLING_MODE      _IOW (IOCTL_AO, 15,unsigned long)
#define IOCTL_GET_BURSTING_STATUS       _IOW (IOCTL_AO, 16,unsigned long)
#define IOCTL_BURST_TRIGGER             _IO  (IOCTL_AO, 17)
#define IOCTL_ENABLE_REMOTE_GND_SENSE   _IO  (IOCTL_AO, 18)
#define IOCTL_DISABLE_REMOTE_GND_SENSE  _IO  (IOCTL_AO, 19)
#define IOCTL_SELECT_OUT_CLKING_MODE    _IOW (IOCTL_AO, 20,unsigned long)
#define IOCTL_SELECT_CLK_SOURCE         _IOW (IOCTL_AO, 21,unsigned long)
#define IOCTL_GET_CLK_STATUS            _IOR (IOCTL_AO, 22,unsigned long)
#define IOCTL_SINGLE_OUTPUT_CLK_EVT     _IO  (IOCTL_AO, 23)
#define IOCTL_SELECT_BUF_CONFIG         _IOW (IOCTL_AO, 24,unsigned long)
#define IOCTL_LOAD_ACCESS_REQ           _IO  (IOCTL_AO, 25)
#define IOCTL_GET_CIR_BUF_STATUS        _IOR (IOCTL_AO, 26,unsigned long)
#define IOCTL_CLEAR_BUFFER              _IO  (IOCTL_AO, 27)
#define IOCTL_GET_DEVICE_TYPE           _IOR (IOCTL_AO, 28,unsigned long)
#define IOCTL_SET_TIMEOUT               _IOW (IOCTL_AO, 29,unsigned long)
#define IOCTL_SET_ADJUSTABLE_CLOCK      _IOW (IOCTL_AO, 30,unsigned long)
#define IOCTL_ENABLE_ADJUSTABLE_CLOCK   _IOW (IOCTL_AO, 31,unsigned long)
#define IOCTL_SELECT_INTERNAL_CLOCK_SRC _IOW (IOCTL_AO, 32,unsigned long)

/*************************************************************************
** IOCTL_NO_COMMAND
**
** Parameter = NONE
**/

/*************************************************************************
** IOCTL_READ_REGISTER    
** IOCTL_WRITE_REGISTER   
**
** Parameter = REGISTER_PARAMS *pRegParams;
**
** This structure is used to store information about a register. The
** IOCTL_READ_REGISTER and IOCTL_WRITE_REGISTER ioctl commands use this
** structure to read a particular register and to write a value into a particular
** register. 'eRegister' stores the index of the register, range being 0-94, and
** 'ulValue' stores the register value, range being 0x0-0xFFFFFFFF.
**/
typedef struct register_params {
    unsigned int eRegister;             /* range: 0-94, see definitions below */
    unsigned long ulValue;      /* range: 0x0-0xFFFFFFFF, same register values below */
} REGISTER_PARAMS, *PREGISTER_PARAMS;

/* ==== Register Offsets ==== */
/* ---- Local Registers ---- */

#define BOARD_CTRL_REG                      0
#define DIGITAL_BYTE_PORT                   1
#define RATE_CTRL_REG                       2
#define BUFFER_OPS_REG                      3
#define RESERVED_1                          4
#define RESERVED_2                          5
#define OUTPUT_BUF_REG                      6
#define ADJUSTABLE_CLOCK                    7
#define INTERNAL_CLOCK_SOURCE               8
#define LAST_LOCAL_REGISTER                 8

/********************************************************************/
/* ==== Values for some key registers ==== */

/* ---- masks for the Board Control Register. ---- */

#define BCR_BURST_ENABLED            (1<<0)
#define BCR_BURST_READY              (1<<1)
#define BCR_BURST_TRIGGER            (1<<2)
#define BCR_REMOTE_GROUND_SENSE      (1<<3)
#define BCR_OFFSET_BINARY            (1<<4)
#define BCR_SIMULTANEOUS_OUTPUTS     (1<<7)
#define BCR_IRQ_SHIFT                8
#define BCR_INTERRUPT_REQUEST_FLAG   (1<<11)
#define BCR_BIT_STATUS_FLAG          (1<<14)
#define BCR_INITIALIZE               (1<<15)

/* masks for the interrupt bits */

#define BCR_IRQ_INIT                    (0<<BCR_IRQ_SHIFT)
#define BCR_IRQ_AUTOCAL_COMPLETE        (1<<BCR_IRQ_SHIFT)
#define BCR_IRQ_OUT_BUFFER_EMPTY        (2<<BCR_IRQ_SHIFT)
#define BCR_IRQ_OUT_BUFFER_LOW_QUARTER  (3<<BCR_IRQ_SHIFT)
#define BCR_IRQ_OUT_BUFFER_HIGH_QUARTER (4<<BCR_IRQ_SHIFT)
#define BCR_IRQ_BURST_TRIGGER_READY     (5<<BCR_IRQ_SHIFT)
#define BCR_IRQ_LOAD_READY              (6<<BCR_IRQ_SHIFT)
#define BCR_IRQ_END_LOAD_READY          (7<<BCR_IRQ_SHIFT)

#define BCR_IRQ_MASK (7<<BCR_IRQ_SHIFT) /* mask off all IRQ source bits */

/* masks for calibration mode */

#define BCR_CALIBRATION_MODE_MASK (3<<12)
#define BCR_NO_CALIBRATION         0
#define BCR_INIT_CALIBRATION      (2<<12)

/* ---- masks for the output data buffer. ---- */

#define ODB_DATA_MASK 0xffff
#define ODB_EOF_FLAG (1<<16)

/* ---- masks for the sample rate register. ---- */

#define SRC_MAX 0xFFFF

/* ---- masks for the buffer operations register. ---- */

//masks for buffer size 
#define BOR_BUFFER_SIZE_MASK 0x0F

#define OUT_BUFFER_SIZE_4     0
#define OUT_BUFFER_SIZE_8     1
#define OUT_BUFFER_SIZE_16    2 
#define OUT_BUFFER_SIZE_32    3
#define OUT_BUFFER_SIZE_64    4
#define OUT_BUFFER_SIZE_128   5
#define OUT_BUFFER_SIZE_256   6
#define OUT_BUFFER_SIZE_512   7
#define OUT_BUFFER_SIZE_1024  8
#define OUT_BUFFER_SIZE_2048  9
#define OUT_BUFFER_SIZE_4096  0xA
#define OUT_BUFFER_SIZE_8192  0xB
#define OUT_BUFFER_SIZE_16384 0xC
#define OUT_BUFFER_SIZE_32768 0xD
#define OUT_BUFFER_SIZE_65536 0xE
#define OUT_BUFFER_SIZE_131072 0xF

#define BOR_EXTERNAL_CLOCK      (1<<4)
#define BOR_ENABLE_CLOCK        (1<<5)
#define BOR_CLOCK_READY         (1<<6)
#define BOR_SW_CLOCK            (1<<7)
#define BOR_CIRCULAR_BUFFER     (1<<8)
#define BOR_LOAD_REQUEST        (1<<9)
#define BOR_LOAD_READY          (1<<10)
#define BOR_CLEAR_BUFFER        (1<<11)
#define BOR_BUFFER_EMPTY        (1<<12)
#define BOR_BUFFER_LOW_QUARTER  (1<<13)
#define BOR_BUFFER_HIGH_QUARTER (1<<14)
#define BOR_BUFFER_FULL         (1<<15)

/* ---- masks for the adjustable clock register. ---- */

#define ACR_CLOCK_RATE_MASK 0x1FF
#define ACR_ADJUSTABLE_CLOCK_SELECT (1<<9)

// masks for the internal clock source control register

#define ICS_DIVIDED 0 /* used the divided master or adjustable clock */
#define ICS_FIXED_1 1
#define ICS_FIXED_2 2
#define ICS_FIXED_3 3
#define ICS_FIXED_4 4
#define ICS_FIXED_5 5
#define ICS_FIXED_6 6
#define ICS_FIXED_7 7
#define ICS_FIXED_8 8

/*************************************************************************
**  IOCTL_INIT_BOARD
**
** Initialize the hardware to a known state.
**
**  Parameter = NONE
**/

/*************************************************************************
**  IOCTL_SET_DMA_MODE
**
** selects if DMA operations are enabled, disabled or demand mode.  
** Parameter = PINT pbDMAEnable;
*/
enum {
    DMA_DISABLE,
    DMA_ENABLE,
//DMA_DEMAND_MODE // not available on this hardware
};

/*************************************************************************
**  IOCTL_GET_DEVICE_ERROR
**
** returns the last error code.  

**  Parameter = unsigned long *pError
**
** Possible error codes are:
**/
    enum {
        NO_ERR,
        INVALID_PARAMETER_ERR,
        RESOURCE_ERR,
        BOARD_ACCESS_ERR,
        DEVICE_ADD_ERR,
        ALREADY_OPEN_ERR,
        INVALID_BOARD_STATUS_ERR,
        FIFO_BUFFER_ERR
    };

/*************************************************************************
** IOCTL_AUTOCALIBRATE
**
** Run an auto-calibration cycle on the hardware.  The driver waits for
** the auto-calibration complete interrupt.
**
** Parameter = none
**
**/

/*************************************************************************
** IOCTL_PROGRAM_RATE_GEN
**
** Set the divisor value for the rate generator.  The frequency at which
** the channels are scanned and sampled is :
**
** Frequency (Hz) = 30,000,000/nrate
**
** Parameter = unsigned long *nrate;
** Range: 0-0xFFFF 
**/
#define MAX_RATE_GEN 0xffff

/*************************************************************************
** IOCTL_SET_OUT_BUFFER_SIZE
**
**
** Set the size of the output buffer in bytes. 
** Parameter = ulong *ulSize;
**
**  Possible values are:

  OUT_BUFFER_SIZE_4
  OUT_BUFFER_SIZE_8
  OUT_BUFFER_SIZE_16
  OUT_BUFFER_SIZE_32
  OUT_BUFFER_SIZE_64
  OUT_BUFFER_SIZE_128
  OUT_BUFFER_SIZE_256
  OUT_BUFFER_SIZE_512
  OUT_BUFFER_SIZE_1024
  OUT_BUFFER_SIZE_2048
  OUT_BUFFER_SIZE_4096
  OUT_BUFFER_SIZE_8192
  OUT_BUFFER_SIZE_16384
  OUT_BUFFER_SIZE_32768
  OUT_BUFFER_SIZE_65536
**/

/*************************************************************************
** IOCTL_GET_BUFFER_STATUS
**
** Get the current output buffer status
**
** Parameter = unsigned long *status;
**
** The return value is one of the following:
**/

#define   OUTPUT_EMPTY    (1<<12)
#define   OUTPUT_LOW_QTR  (1<<13)
#define   OUTPUT_HIGH_QTR (1<<14)
#define   OUTPUT_FULL     (1<<15)
#define BUFFER_STATUS_MASK (0x0f<<12)

/*************************************************************************
** IOCTL_ENABLE_CLK
**
** Enable output clocking.
**
** Parameter = not used;
**/

/*************************************************************************
** IOCTL_DISABLE_CLK
**
** Disable output clocking.
**
** Parameter = not used;
**/

/*************************************************************************
** IOCTL_SELECT_DATA_FORMAT
**
** Parameter = int *pulFormat;
** 
** Possible Values are:
**/
#define TWOS_COMP 0
#define OFFSET_BINARY 1 

/*************************************************************************
** IOCTL_SELECT_SAMPLING_MODE
**
** Parameter: long *ulMode
** 
** Possible values are:
**
**/

#define CONT_MODE 0
#define BURST_MODE 1

/*************************************************************************
** IOCTL_GET_BURSTING_STATUS
**
** Parameter: long *ulStatus
** 
** Possible values are:
**
**/

#define BURST_NOT_READY 0
#define BURST_READY BCR_BURST_READY

/*************************************************************************
** IOCTL_BURST_TRIGGER
**
** Start a burst-mode transfer of data from the output buffer to the selected
** active channels.
**
** Parameter = none;
**
**/

/*************************************************************************
** IOCTL_ENABLE_REMOTE_GND_SENSE
**
** Set the hardware to use remote ground sense mode.
**
** Parameter = none;
**
**/

/*************************************************************************
** IOCTL_DISABLE_REMOTE_GND_SENSE
**
** Set the hardware to use on-board ground reference.
**
** Parameter = none;
**
**/

/*************************************************************************
** IOCTL_SELECT_OUT_CLKING_MODE
**
** Parameter: long *ulMode
** 
** Possible values are:
**
**/
enum {
    SEQUENTIAL,
    SIMULTANEOUS
};

/*************************************************************************
** IOCTL_SELECT_CLK_SOURCE
**
** Parameter: long *ulMode
** 
** Possible values are:
**
**/
enum {
    INTERNAL,
    EXTERNAL
};

/*************************************************************************
** IOCTL_GET_CLK_STATUS
**
** Parameter: long *ulMode
** 
**
** returns one of the following:
**/

#define CLOCK_NOT_READY 0
#define CLOCK_READY BOR_CLOCK_READY

/*************************************************************************
** IOCTL_SINGLE_OUTPUT_CLK_EVENT
**
** Generate a clock strobe.
**
** Parameter = none;
**
**/

/*************************************************************************
** IOCTL_SELECT_BUF_CONFIG
**
** Parameter: long *ulConfig
** 
** Possible values are:
**
**/

#define OPEN_BUF 0
#define CIRCULAR_BUF (1<<8)

/*************************************************************************
** IOCTL_LOAD_ACCESS_REQ
**
** Request access to the circular (closed) buffer.
**
** Parameter = none;
**
**/

/*************************************************************************
** IOCTL_GET_CIR_BUF_STATUS
**
** Parameter: long *ulStatus
** 
** Possible values are:
**
**/

#define CIR_BUF_NOT_READY 0
#define CIR_BUF_READY BOR_LOAD_READY

/*************************************************************************
** IOCTL_CLEAR_BUFFER
**
** Clear data from the output buffer.
**
** Parameter = none;
**
**/

/*************************************************************************
** IOCTL_GET_DEVICE_TYPE
**
** Returns an enumeration for the type of hardware.
**
** Parameter = none;
**
** Possible return values are:
**
**/

enum
{
    GSC_16AO4MF,
};

/*************************************************************************
** IOCTL_SET_TIMEOUT
**
** Sets the timeout, in seconds, for read, auto calibration and
** initialization operations in seconds.
**
** Parameter = unsigned long;
**
**/

/*************************************************************************
** IOCTL_SET_ADJUSTABLE_CLOCK
**
** Sets frequency of the adjustable clock.
**
** Parameter = unsigned long;
**
** Range: 0-0x0F
**
**
**/

/*************************************************************************
** IOCTL_ENABLE_ADJUSTABLE_CLOCK
**
** Sets the timeout, in seconds, for read, auto calibration and
** initialization operations.
**
** Parameter = unsigned long;
**
**
**/

/*************************************************************************
** IOCTL_SELECT_INTERNAL_CLOCK_SRC
**
** Sets the timeout, in seconds, for read, auto calibration and
** initialization operations.
**
** Parameter = unsigned long;
**
**
**/

#endif  /* entire file */

