/***
*** proc.c
***
***  General description of this file:
***     Device driver source code for General Standards 
***     family of analog I/O boards. This file is part of the Linux
***     driver source distribution for this board.
***
***  Copyrights (c):
***     General Standards Corporation (GSC), 2005-2006
***
***  Author:
***     Evan Hillman (evan@generalstandards.com)
***
***  Support:
***     Primary support for this driver is provided by GSC. 
***
***  Platform (tested on, may work with others):
***     Linux, kernel version 2.4.x, 2.6.x,  Red Hat distribution, Intel hardware.
***/  
  
//////////////////////////////////////////////////////////////////////////
// set the following flag to trace debug messages in this module.
#ifdef DEBUG
//#define TRACE_LOCAL TRUE
#endif /* 
 */
  
#include "internals.h"
  
/******************************************************************************
*
*   Function:   read_proc
*
*   Purpose:
*
*       Implement the read service for the module's /proc file system
*       entry. Read the documentation on this service for details, as
*       we ignore some arguments according to our needs and the
*       documentation.
*
*   Arguments:
*
*       page    The data produced is put here.
*
*       start   Records pointer to where the data in "page" begins.
*
*       offset  The offset into the file where we're to begin.
*
*       count   The limit to the amount of data we can produce.
*
*       eof Set this flag when we hit EOF.
*
*       data    A private data item that we may use, but don't.
*
*   Returned:
*
*       int The number of characters written.
*
******************************************************************************/ 
/**
 * 
 * @param page 
 * @param start 
 * @param offset 
 * @param count 
 * @param eof 
 * @param data 
 * @return 
 */ 
  int
read_proc (
char *page, 
char **start, 
off_t offset, 
int count, 
int *eof,
	   
void *data) 
{
  
#define _PROC_MSG_SIZE  128
    
#if PAGE_SIZE < _PROC_MSG_SIZE
#error  "/proc file size may be too big."
#endif /* 
 */
  int i;
  
#ifdef TRACE_LOCAL
  int j;
  
char str[256];
  
#endif /* 
 */
    
MOD_INC_USE_COUNT;
  
i = sprintf (page, 
"version: %s\n" 
		"built: %s\n" 
		"boards: %d\n", 
DRIVER_VERSION, 
built, 
num_boards);
  
page[i] = 0;
  

#ifdef TRACE_LOCAL
    strcat (page, "Debug Stats:\n ");
  
strcat (page,
	   "type\tother_ints\ttotal_ints\tdma_ints\tchan_irq\tchan_expect\n");
  

for (j = 0; j < num_boards; j++)
    {
      
sprintf (str, "%d\t\t%d\t\t%d\t\t%d\t\t%d\t\t%d\t\t%p\n",
		
board_type[j], 
int_other_count[j], 
int_count[j],
		
dma_count[j], 
channel_irq[j], 
channel_expected[j],
		
context[j] 
);
      
strcat (page, str);
    
}
  

#endif /* 
 */
    strcat (page, "\n");
  
i = strlen (page) + 1;
  

if (i >= PAGE_SIZE)
    {
      
printk (KERN_INFO GSC_NAME "/proc/xxx is larger than PAGE_SIZE\n");
      
i = PAGE_SIZE - 1;
    
}
  

i--;
  
eof[0] = 1;
  
MOD_DEC_USE_COUNT;
  
return (i);

}



/******************************************************************************
*
*   Function:   proc_get_info
*
*   Purpose:
*
*       Implement the get_info() service for /proc file system support.
*
*   Arguments:
*
*       page    The data produced is put here.
*
*       start   Records pointer to where the data in "page" begins.
*
*       offset  The offset into the file where we're to begin.
*
*       count   The limit to the amount of data we can produce.
*
*       dummy   A parameter that is unused (for kernel 2.2 only).
*
*   Returned:
*
*       int The number of characters written.
*
******************************************************************************/ 
  int
proc_get_info (
char *page, 
char **start, 
off_t offset, 
int count,
	       
int dummy) 
{
  
int eof;
  
int i;
  

i = read_proc (page, start, offset, count, &eof, NULL);
  
return (i);

}


