/***
*** mmap.c
***
***  General description of this file:
***     Device driver source code for General Standards 
***     family of analog I/O boards. This file is part of the Linux
***     driver source distribution for this board.
***
***  Copyrights (c):
***     General Standards Corporation (GSC), 2005-2006
***
***  Author:
***     Evan Hillman (evan@generalstandards.com)
***
***  Support:
***     Primary support for this driver is provided by GSC. 
***
***  Platform (tested on, may work with others):
***     Linux, kernel version 2.4.x, 2.6.x,  Red Hat distribution, Intel hardware.
***/  
  
//////////////////////////////////////////////////////////////////////////
// set the following flag to trace debug messages in this module.
  
#ifdef DEBUG
//#define TRACE_LOCAL TRUE
#endif /* 
 */
  
//#include <linux/config.h>
#include <linux/module.h>
  
#include <linux/mm.h>		/* everything */
#include <linux/errno.h>	/* error codes */
#include <asm/pgtable.h>
  
#include "internals.h"
  
/*
* open and close: just keep track of how many times the device is
* mapped, to avoid releasing it.
*/ 
  
void
device_vma_open (struct vm_area_struct *vma) 
{
  
struct device_board *device = vma->vm_private_data;
  
#ifdef SUPPORT_READ
    if (vma->vm_flags & VM_READ)
    
    {
      
msg ("device_vma_nopage - VM_READ\n");
      
device->dmaData[RX].vmas++;
    
}
  
#endif /* 
 */
    
#ifdef SUPPORT_WRITE
    if (vma->vm_flags & VM_WRITE)
    
    {
      
msg ("device_vma_nopage - VM_WRITE\n");
      
device->dmaData[TX].vmas++;
    
}
  
#endif /* 
 */
}


void
device_vma_close (struct vm_area_struct *vma) 
{
  
struct device_board *device = vma->vm_private_data;
  

#ifdef SUPPORT_READ
    if (vma->vm_flags & VM_READ)
    
    {
      
msg ("device_vma_nopage - VM_READ\n");
      
device->dmaData[RX].vmas--;
    
}
  
#endif /* 
 */
    
#ifdef SUPPORT_WRITE
    if (vma->vm_flags & VM_WRITE)
    
    {
      
msg ("device_vma_nopage - VM_WRITE\n");
      
device->dmaData[TX].vmas--;
    
}
  
#endif /* 
 */
}



/*
* The nopage method: the core of the file. It retrieves the
* page required from the device device and returns it to the
* user. The count for the page must be incremented, because
* it is automatically decremented at page unmap.
*
* For this reason, "order" must be zero. Otherwise, only the first
* page has its count incremented, and the allocating module must
* release it as a whole block. Therefore, it isn't possible to map
* pages from a multipage block: when they are unmapped, their count
* is individually decreased, and would drop to 0.
*/ 

struct page *
device_vma_nopage (struct vm_area_struct *vma, 
unsigned long address,
		   int *type) 
{
  
unsigned long offset;
  

int direction = RX;
  

    //struct device_board *ptr, *device = vma->vm_private_data;
  struct device_board *device = vma->vm_private_data;
  
struct page *page = NOPAGE_SIGBUS;
  
void *pageptr = NULL;	// default to "missing"
  int handled = FALSE;
  

#ifdef SUPPORT_READ
    if (vma->vm_flags & VM_READ)
    
    {
      
msg ("device_vma_nopage - VM_READ\n");
      
direction = RX;
      
handled = TRUE;
    
}
  
#endif /* 
 */
#ifdef SUPPORT_WRITE
    if (vma->vm_flags & VM_WRITE)
    
    {
      
msg ("device_vma_nopage - VM_WRITE\n");
      
direction = TX;
      
handled = TRUE;
    
}
  
#endif /* 
 */
    if (!handled)
    
    {
      
errmsg ("device_vma_nopage - ERROR\n");
      
return page;
    
}
  

offset = (address - vma->vm_start) + (vma->vm_pgoff << PAGE_SHIFT);
  
    //msg("device_vma_nopage offset: %ld 0x%lX\n", offset, offset);
    if (offset >= device->dmaData[direction].dmaSize)
    
    {
      
errmsg ("mmap offset out of range\n");
      
goto out;		// out of range 
    }
  

offset >>= PAGE_SHIFT;	// offset is a number of pages 
  //msg("device_vma_nopage address: %lX device %p size: %X page offset: %ld\n", address, device, device->dmaSize,offset);
  pageptr = device->dmaData[direction].sgPages[offset];
  
if (!pageptr)
    goto out;			// hole or end-of-file 
  page = virt_to_page (pageptr);
  

    // got it, now increment the count 
    get_page (page);
  
if (type)
    
*type = VM_FAULT_MINOR;

out:
    //   up(&dev->sem);
    return page;

}


struct vm_operations_struct device_vm_ops = 
  { 
.open = device_vma_open, 
.close = device_vma_close, 
.nopage =
device_vma_nopage, 
};


int
device_mmap (struct file *filp, struct vm_area_struct *vma) 
{
  
    //struct inode *inode = filp->f_dentry->d_inode;
    // int i;
  struct device_board *device = (struct device_board *) filp->private_data;
  
unsigned long bufferSize;
  
int direction = RX;
  
int handled = FALSE;
  

#ifdef SUPPORT_READ
    if (vma->vm_flags & VM_READ)
    
    {
      
msg ("device_vm_ops - VM_READ\n");
      
direction = RX;
      
handled = TRUE;
    
}
  
#endif /* 
 */
#ifdef SUPPORT_WRITE
    if (vma->vm_flags & VM_WRITE)
    
    {
      
msg ("device_vm_ops - VM_WRITE\n");
      
direction = TX;
      
handled = TRUE;
    
}
  
#endif /* 
 */
    if (!handled)
    
    {
      
errmsg ("device_vm_ops - ERROR\n");
      
return -EFAULT;
    
}
  

    //int numPages;
    
bufferSize = vma->vm_end - vma->vm_start;
  
device->dmaData[direction].dmaSize = bufferSize;
  
    //numPages = bufferSize/PAGE_SIZE;
    //msg("mmap called, vma: %p buffer size %lX pages: %X, max segments: %ld\n",vma,bufferSize,numPages,SG_PAGES);
    device->dmaData[direction].useMmap = TRUE;
  

    //#ifdef TRACE_LOCAL
    //        {
    //            static unsigned long value;
    //            int q;
    //            for (q=0;PAGE_SIZE;q++)
    //            {
    ////                *device->sgPages[i][q]=value;
    //            }
    //            value++;
    //        }
    //#endif
    //    }
    
    /* don't do anything here: "nopage" will set up page table entries */ 
    
vma->vm_ops = &device_vm_ops;
  
vma->vm_flags |= VM_RESERVED;
  
vma->vm_private_data = filp->private_data;
  
device_vma_open (vma);
  
msg ("device_mmap - done\n");
  

return 0;

}



