/***
*** ioctl.c
***
***  General description of this file:
***     Device driver source code for General Standards 
***     family of analog I/O boards. This file is part of the Linux
***     driver source distribution for this board.
***
***  Copyrights (c):
***     General Standards Corporation (GSC), 2005-2006
***
***  Author:
***     Evan Hillman (evan@generalstandards.com)
***
***  Support:
***     Primary support for this driver is provided by GSC. 
***
***  Platform (tested on, may work with others):
***     Linux, kernel version 2.4.x, 2.6.x,  Red Hat distribution, Intel hardware.
***/  
  

//////////////////////////////////////////////////////////////////////////
// set the following flag to trace interrupt debug messages.
#ifdef DEBUG
#define TRACE_LOCAL TRUE
#endif /* 
 */
  
#include "internals.h"
  
//////////////////////////////////////////////////////////////////////////
// main ioctl function dispatch
// 'break' at the end of branches which need to wait for the
// channels ready condition, 'return' from others
#ifdef RTL
  int
device_ioctl (struct rtl_file *fp, unsigned int ioctl, unsigned long arg) 
#else /* 
 */
  int
device_ioctl (struct inode *inode, struct file *fp, unsigned int ioctl,
	      unsigned long arg) 
#endif				/* 
 */
{
  
struct device_board *device;
  
struct device_register_params regs;
  
//  struct gen_rate_params ratecfg;
  struct gen_assign_params asgncfg;
  
u32 ulval, regval;
  
int ival;
  
u32 readyval;
  
int currentEvent;
  
int retval;
  

#ifdef RTL
    device = (struct device_board *) fp->f_priv;
  
#else /* 
 */
    device = (struct device_board *) fp->private_data;
  
#endif /* 
 */
    // clear the existing interrupt state.  Since the driver only does one thing at once,
    // and always waits for pending interrupts, it may be assumed that the interrupt is
    // not active while
    
DisableIrqLocalAll (device);
  
DisableIrqPlx (device);
  
retval = 0;
  

switch (ioctl)
    
    {
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_NO_COMMAND:
      
	//msg( ":     base_address[0]=0x%lX, base_address[2]=0x%lX \n", device->pHardware->pdev->resource[0].start, device->pHardware->pdev->resource[2].start);
	regdump (device, "no-op ");
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_READ_REGISTER:
      
	//msg( "(%d): IOCTL_DEVICE_READ_REGISTER reg %d\n",device->minor, regs.ulRegister);
	copy_from_user_ret (&regs, (void *) arg, sizeof (regs), (-EFAULT));
      
if ((regs.ulRegister < BOARD_CTRL_REG) || (regs.ulRegister > LAST_REG))
	
	{
	  
goto invalidParam;
	
}
      

regval = regs.ulRegister;
      

regs.ulValue =
	readl (device->pHardware->local_addr + regs.ulRegister);
      
copy_to_user_ret ((void *) arg, &regs, sizeof (regs), (-EFAULT));
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_WRITE_REGISTER:
      
msg ("(%d): IOCTL_DEVICE_WRITE_REGISTER\n", device->minor);
      
copy_from_user_ret (&regs, (void *) arg, sizeof (regs), (-EFAULT));
      

regval = regs.ulRegister;
      
ulval = regs.ulValue;
      

if ((regs.ulRegister < BOARD_CTRL_REG)
	    || (regs.ulRegister > LAST_REG))
	
	{
	  
goto invalidParam;
	
}
      
writel (regs.ulValue, device->pHardware->local_addr + regs.ulRegister);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_INPUT_RANGE:
      
msg ("(%d): IOCTL_SET_INPUT_RANGE\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval < RANGE_2p5V) || (ulval > RANGE_10V))
	
	{
	  
goto invalidParam;
	
}
      
andOrLocal (device, BOARD_CTRL_REG,
		   ~(BCR_RANGE_MASK << BCR_RANGE_SHIFT),
		   ulval << BCR_RANGE_SHIFT);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_INPUT_MODE:
      
msg ("(%d): IOCTL_SET_INPUT_MODE\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval < MODE_DIFFERENTIAL) || (ulval > MODE_VREF_TEST))
	
	{
	  
goto invalidParam;
	
}
      
msg ("setting input mode %d\n", ulval);
      
mark (0x44444444);
      
andOrLocal (device, BOARD_CTRL_REG, ~(BCR_AIM_MASK << BCR_AIM_SHIFT),
		   ulval << BCR_AIM_SHIFT);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_SW_SYNC:
      
msg ("(%d): IOCTL_SET_SW_SYNC\n", device->minor);
      
get_user_ret (ival, (int *) arg, (-EFAULT));
      
ival = ival ? 1 : 0;
      

if (ival)
	
	{
	  
orLocal (device, BOARD_CTRL_REG, BCR_SW_SYNC_MASK);
	
}
      
      else
	
	{
	  
andLocal (device, BOARD_CTRL_REG, ~BCR_SW_SYNC_MASK);
	
}
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_AUTO_CAL:
      
msg ("(%d): IOCTL_AUTO_CAL\n", device->minor);
      
retval = doAutocal (device);
      
return retval;
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_INITIALIZE:
      
msg ("(%d): IOCTL_INITIALIZE\n", device->minor);
      
retval = doInit (device);
      
return retval;
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_DATA_FORMAT:
      
msg ("(%d): IOCTL_SET_DATA_FORMAT\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval != FORMAT_TWOS_COMPLEMENT)
	   && (ulval != FORMAT_OFFSET_BINARY))
	
	{
	  
goto invalidParam;
	
}
      
andOrLocal (device, BOARD_CTRL_REG, ~(BCR_OFFSET_BINARY_MASK),
		   ulval << BCR_OFFSET_BINARY_SHIFT);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_INITIATOR_MODE:
      
msg ("(%d): IOCTL_SET_INITIATOR_MODE\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval != INITIATOR_MODE) && (ulval != TARGET_MODE))
	
	{
	  
goto invalidParam;
	
}
      
andOrLocal (device, BOARD_CTRL_REG, ~(BCR_INITIATOR_MASK),
		   ulval << BCR_INITIATOR_SHIFT);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_BUFFER_THRESHOLD:
      
msg ("(%d): IOCTL_SET_BUFFER_THRESHOLD\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if (ulval > INPUT_BUFFER_SIZE)
	
	{
	  
goto invalidParam;
	
}
      
andOrLocal (device, BUFFER_CONTROL_REG, ~(BUCR_THRESHOLD_MASK), ulval);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_CLEAR_BUFFER:
      
msg ("(%d): IOCTL_CLEAR_BUFFER\n", device->minor);
      
orLocal (device, BUFFER_CONTROL_REG, BUCR_CLEAR_BUFFER_MASK);
      
andLocal (device, BUFFER_CONTROL_REG, ~BUCR_BUFFER_OVERFLOW);
      
andLocal (device, BUFFER_CONTROL_REG, ~BUCR_BUFFER_UNDERFLOW);
      
#ifdef TRACE_LOCAL
	device->last = 0;
      
#endif /* 
 */
	break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_ACQUIRE_MODE:
      
msg ("(%d): IOCTL_SET_ACQUIRE_MODE\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval != START_ACQUIRE) && (ulval != STOP_ACQUIRE))
	
	{
	  
goto invalidParam;
	
}
      
andOrLocal (device, BUFFER_CONTROL_REG, ~(BUCR_DISABLE_BUFFER_MASK),
		   ulval << BUCR_DISABLE_BUFFER_SHIFT);
      
break;
      


	//////////////////////////////////////////////////////////////////////////
    case IOCTL_ASSIGN_RATE_GROUP:
      
msg ("(%d): IOCTL_ASSIGN_GEN_TO_GROUP\n", device->minor);
      
copy_from_user_ret (&asgncfg, (void *) arg, sizeof (asgncfg),
			   (-EFAULT));
      
if ((asgncfg.eGroup < GRP_0) || (asgncfg.eGroup > GRP_3)
	   || 
(asgncfg.eGenAssign < RA_GROUP_0_INTERNAL)
	   || (asgncfg.eGenAssign > RA_LAST))
	
	{
	  
goto invalidParam;
	
}
      
andOrLocal (device, RATE_ASSIGN_REG,
		   ~((RA_GROUP_MASK << GroupShift[asgncfg.eGroup])),
		   asgncfg.eGenAssign << GroupShift[asgncfg.eGroup]);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_RATE_DIVISOR:
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
msg ("(%d): IOCTL_SET_RATE_DIVISOR \n", device->minor);
      
if ((ulval < NDIV_MIN) || (ulval > NDIV_MAX))
	
	{
	  
goto invalidParam;
	
}
      
writeLocal (device, RATE_DIVISOR_REG, ulval);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_TIMEOUT:
      
msg ("(%d): IOCTL_SET_TIMEOUT\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
device->timeout_seconds = ulval;
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_DMA_STATE:
      
msg ("(%d): IOCTL_SET_DMA_STATE\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval < DMA_DISABLE) || (ulval > DMA_DEMAND_MODE))
	
	{
	  
goto invalidParam;
	
}
      
device->dmaData[RX].dmaState = ulval;
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_FILL_BUFFER:
      
msg ("(%d): IOCTL_FILL_BUFFER\n", device->minor);
      
get_user_ret (ival, (int *) arg, (-EFAULT));
      
ival = ival ? 1 : 0;
      
device->fillBuffer = ival;
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SYNCRONIZE_SCAN:
      
msg ("(%d): IOCTL_SYNCRONIZE_SCAN\n", device->minor);
      
get_user_ret (ival, (int *) arg, (-EFAULT));
      
ival = ival ? 1 : 0;
      

if (ival)
	
	{
	  
orLocal (device, BOARD_CTRL_REG, BCR_SYNCHRONIZE_SCAN);
	  
	    //msleep(100);
	}
      
      else
	
	{
	  
andLocal (device, BOARD_CTRL_REG, ~(BCR_SYNCHRONIZE_SCAN));
	
}
      
break;
      


	//////////////////////////////////////////////////////////////////////////
    case IOCTL_CLEAR_BUFFER_SYNC:
      
msg ("(%d): IOCTL_CLEAR_BUFFER_SYNC\n", device->minor);
      
get_user_ret (ival, (int *) arg, (-EFAULT));
      
ival = ival ? 1 : 0;
      
if (ival)
	
	{
	  
orLocal (device, BOARD_CTRL_REG, BCR_CLEAR_BUFFER_ON_SYNC);
	
}
      
      else
	
	{
	  
andLocal (device, BOARD_CTRL_REG, ~(BCR_CLEAR_BUFFER_ON_SYNC));
	
}
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_OVERFLOW_CHECK:
      
msg ("(%d): IOCTL_SET_OVERFLOW_CHECK\n", device->minor);
      
get_user_ret (ival, (int *) arg, (-EFAULT));
      
ival = ival ? 1 : 0;
      
device->detectOverflow = ival;
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SELECT_IMAGE_FILTER:
      
msg ("(%d): IOCTL_SELECT_IMAGE_FILTER\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval != IMAGE_FILTER_LO_FREQ) && (ulval != IMAGE_FILTER_HI_FREQ))
	
	{
	  
goto invalidParam;
	
}
      
andOrLocal (device, BOARD_CTRL_REG, ~(BCR_SELECT_IMAGE_FILTER), ulval);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_DATA_WIDTH:
      
msg ("(%d): IOCTL_SET_DATA_WIDTH\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval < DATA_WIDTH_16) || (ulval > DATA_WIDTH_24))
	
	{
	  
goto invalidParam;
	
}
      
andOrLocal (device, BUFFER_CONTROL_REG, ~(BUCR_DATA_WIDTH_MASK),
		   ulval << BUCR_DATA_WIDTH_SHIFT);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_NREF:
      
msg ("(%d): IOCTL_SET_NREF\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval < NREF_MIN) || (ulval > NREF_MAX))
	
	{
	  
goto invalidParam;
	
}
      
writeLocal (device, NREF_PLL_CONTROL_REG, ulval);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_SET_NVCO:
      
msg ("(%d): IOCTL_SET_NVCO\n", device->minor);
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
if ((ulval < NVCO_MIN) || (ulval > NVCO_MAX))
	
	{
	  
goto invalidParam;
	
}
      
writeLocal (device, NVCO_PLL_CONTROL_REG, ulval);
      
break;
      

//////////////////////////////////////////////////////////////////////////
    case IOCTL_GET_REF_FREQUENCY:
      
regval = readLocal (device, PLL_REF_FREQ_REG);
      
put_user_ret (regval, (unsigned long *) arg, (-EFAULT));
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    case IOCTL_GSC_SET_RANGE_FILTER:
      
get_user_ret (ulval, (unsigned long *) arg, (-EFAULT));
      
msg ("(%d): IOCTL_GSC_SET_RANGE_FILTER \n", device->minor);
      
writeLocal (device, RANGE_FILTER_CONTROL, ulval);
      
break;
      

	//////////////////////////////////////////////////////////////////////////
    default:
      
msg ("(%d): Invalid IOCTL\n", device->minor);
      
return (-EINVAL);
    
}				// switch
  
msg ("CHANNELS_READY begin BCR: %.8X\n",
	readLocal (device, BOARD_CTRL_REG));
  
    // check to see if should wait for CHANNELS_READY interrupt.
    
currentEvent = EVENT_CHANNELS_READY;
  
readyval = readLocal (device, BOARD_CTRL_REG) & BCR_CHAN_READY_MASK;
  
    //msg("readyval: %.8X BCR: %X\n",readyval,readLocal(device,BOARD_CTRL_REG));
    
if (readyval)		// no need to wait
    {
      
msg ("CHANNELS_READY nowait BCR: %.8X\n",
	    readLocal (device, BOARD_CTRL_REG));
      
return 0;
    
}
  
    // 10 ms delay to settle.
SET_CURRENT_STATE(TASK_UNINTERRUPTIBLE);
if (schedule_timeout(10 * HZ / 1000) > 0) // interrupted by signal
    return (-EIO);
  
    // else fall through to CHANNELS_READY IRQ wait...
//  msg("CHANNELS_READY   wait BCR: %.8X\n",readLocal(device,BOARD_CTRL_REG));
//
//  // see if we need to wait for the channels ready condition
//  setupEvent(device,currentEvent);
//
//  setupWatchdog(device,RX,device->timeout_seconds);
//
//#ifdef TRACE_LOCAL
//  //regval = readlocal(device,BOARD_CTRL_REG);
//  //msg("Sleep BCR: %.8X\n",regval);
//#endif
//  retval = waitEvent(device,currentEvent);
//  retval |= cleanupWatchdog(device, RX);
//  cleanupEvent(device,currentEvent);
//
//  if (retval != 0)
//  {
//    errmsg( "(%d): chready_pending timeout\n", device->minor);
//    return (-EIO);
//  }
    
return (retval);


invalidParam:
up (&device->hwSem);
  
#ifdef SERIALIZE
    clearEvent (EVENT_HARDWARE_BUSY);	// release the hardware.
  mark (0xdead0007);
  
wake_up_interruptible (&device->wq[EVENT_HARDWARE_BUSY]);
  
#endif // SERIALIZE
    return (-EIO);
  
//returnNoSem:
    return retval;

}


