/***
*** id.h 
***
***
***  General description of this file:
***     Device driver source code for General Standards 
***     family of analog I/O boards. This file is part of the Linux
***     driver source distribution for this board.
***
***  Copyrights (c):
***     General Standards Corporation (GSC), 2005-2007
***
***  Author:
***     Evan Hillman (evan@generalstandards.com)
***
***  Support:
***     Primary support for this driver is provided by GSC. 
***
***  Platform (tested on, may work with others):
***     Linux, kernel version 2.4.x, 2.6.x,  Red Hat distribution, Intel hardware.
***/  
  
//////////////////////////////////////////////////////////////////////////
// Things that are most likely to change:
  
#define COPYRIGHT_YEAR  "2001-2007"
  
// module name NOTE:  This name must be the same as the driver binary.  The install script
//uses the name of the binary name determine if the driver is installed properly, and the
//driver uses this name to announce itself.  The name of the binary is set in Makefile.
  
#define GSC_DEV_ID  0x2974
#define GSC_NAME GSC_TARGET
  
#define INIT_TIMEOUT_SECONDS    20    /* initialization timeout */
#define AUTOCAL_TIMEOUT_SECONDS 20    /* auto calibration timeout */
#define CH_READY_TIMEOUT_MS     500   /* timeout after channel setup operations */
#define CHANNELS_READY_SLEEP_MS 600   /* milliseconds to wait for channels ready, if applicable */
#define MSECS_TO_SLEEP(MS)      ((MS * HZ) / 1000)
//#define PLX_ID PCI_DEVICE_ID_PLX_9056
#define PLX_ID PCI_DEVICE_ID_PLX_9080
  
#define MAX_BOARDS  10   /* maximum number of boards that driver supports. Arbitrarily chosen, */
  /* change if you can actually support more.                           */ 
  
#define TIMER_DELTA 2  /* timer tic polling rate */
  
// configuration options that allow a more generic code base.
  
#define SUPPORT_MULTI_THREADING
//#define SUPPORT_IO_SPACE
//#define SUPPORT_WRITE
#define SUPPORT_READ
#define SUPPORT_DEMAND_MODE
#define DEVICES_PER_BOARD 1
//#define USE_SECOND_DMA
#define SUPPORT_LOCAL_IRQ
  
#define SUPPORT_BUFFER_UNDERFLOW
#define SUPPORT_BUFFER_OVERFLOW
#ifdef DEBUG
#define CHECK_DATA
#endif /* 
 */
// interrupts and events

enum 
{ 
EVENT_INIT_COMPLETE, 
EVENT_AUTOCAL_COMPLETE, 
EVENT_CHANNELS_READY,
  
EVENT_IN_BUFFER_LO_HI, 
EVENT_IN_BUFFER_HI_LO, 

    //    EVENT_LAST_IRQ_EVENT=EVENT_INIT_COMPLETE,              /* place to stop reading registers */
#ifdef SUPPORT_READ
    EVENT_RX_DMA_PENDING, 
#endif				/* 
 */
#ifdef SUPPORT_WRITE
    EVENT_TX_DMA_PENDING, 
#endif				/* 
 */
    EVENT_ARRAY_SIZE /* for array allocation */  
};


enum
{ 
#ifdef SUPPORT_READ
    RX, 
#endif				/* 
 */
#ifdef SUPPORT_WRITE
    TX, 
#endif				/* 
 */
  NUM_DMA_CHANNELS 
};


#ifndef SUPPORT_LOCAL_IRQ /* timer and local IRQ are mutually exclusive */
#define SUPPORT_TIMER 
#endif /* 
 */
  
#include "gsc24dsi32pll_ioctl.h"
  
