// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/wait_status.c $
// $Rev: 51458 $
// $Date: 2022-08-04 11:13:02 -0500 (Thu, 04 Aug 2022) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_wait_status
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI6LN4AO_IOCTL_WAIT_STATUS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		wait	This is the crieteria to use.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi6ln4ao_wait_status(int fd, int index, int verbose, gsc_wait_t* wait)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Wait Status", index);

	if (wait)
	{
		ret		= dsi6ln4ao_ioctl(fd, DSI6LN4AO_IOCTL_WAIT_STATUS, wait);
		errs	= ret ? 1 : 0;

		if (verbose)
		{
			printf(	"%s  (%ld matching wait%s)\n",
					errs ? "FAIL <---" : "PASS",
					(long) wait->count,
					(wait->count == 1) ? "" : "s");
		}
	}
	else
	{
		errs	= 1;

		if (verbose)
			printf(	"FAIL <---  (NULL pointer)\n");
	}

	return(errs);
}


