// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/rx_io_abort.c $
// $Rev: 51458 $
// $Date: 2022-08-04 11:13:02 -0500 (Thu, 04 Aug 2022) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_rx_io_abort
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI6LN4AO_IOCTL_RX_IO_ABORT service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi6ln4ao_rx_io_abort(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;
	s32			set;

	if (verbose)
		gsc_label_index("Rx I/O Abort", index);

	ret		= dsi6ln4ao_ioctl(fd, DSI6LN4AO_IOCTL_RX_IO_ABORT, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case DSI6LN4AO_IO_ABORT_NO:

			ptr	= "No, Not Aborted";
			break;

		case DSI6LN4AO_IO_ABORT_YES:

			ptr	= "Yes, Aborted";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


