// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/reg_write.c $
// $Rev: 51458 $
// $Date: 2022-08-04 11:13:02 -0500 (Thu, 04 Aug 2022) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_reg_write
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI6LN4AO_IOCTL_REG_WRITE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		reg		This is the register to access.
*
*		set		This is the value to apply.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi6ln4ao_reg_write(int fd, int index, int verbose, u32 reg, u32 set)
{
	gsc_reg_t	arg;
	int			errs;
	int			ret;
	const char*	name;

	if (verbose)
		gsc_label_index("Register Write", index);

	arg.reg		= reg;
	arg.value	= set;
	arg.mask	= 0;	// unused here
	ret			= dsi6ln4ao_ioctl(fd, DSI6LN4AO_IOCTL_REG_WRITE, &arg);
	errs		= ret ? 1 : 0;

	if (verbose)
	{
		name	= dsi6ln4ao_reg_get_name(reg);
		printf(	"%s  (val 0x%08lX, %s)\n",
				errs ? "FAIL <---" : "PASS",
				(unsigned long) set,
				name ? name : "UNKNOWN");
	}

	return(errs);
}


