// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/reg.c $
// $Rev: 53777 $
// $Date: 2023-09-28 12:51:48 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



#if 0
// For file format script
if (verbose)
if (verbose)
#endif

// macros *********************************************************************

#define	_GSC_REG(a)					"GSC " #a, DSI6LN4AO_GSC_##a, 0, 0
#define	SHOW_FIELD(f,l,e,ls,d)		gsc_reg_field_show(width+10,24, value, (f),(l),(e),(ls),(d))



//*****************************************************************************
static int _bctlr_decode(int fd, int supported, u32 value, int width)
{
	static const char*	irq[]	=
	{
		"Initialization Done",
		"Input Ready Low-to-High",
		"AI Threshold Status Low-to-High",
		"AI Threshold Status High-to-Low",
		"AI Buffer Overrun or Underrun",
		"RESERVED",
		"RESERVED",
		"Output Clock Done"
	};

	static const char*	last[]	=
	{
		"0",
		"1",
		"2",
		"3",
		"4",
		"5",
		"RESERVED",
		"RESERVED"
	};

	static const char*	range[]	=
	{
		"+-10 Volts",
		"+-5 Volts",
		"+-2.5 Volts",
		"RESERVED"
	};

	static const char*	aim[]		= { "Single Ended",		"Differential"	};
	static const char*	async[]		= { "Asynchronous",		"Synchronous"	};
	static const char*	clear[]		= { "Clear",			"Set"			};
	static const char*	clk_src[]	= { "Internal",			"External"		};
	static const char*	coupling[]	= { "AC",				"DC"			};
	static const char*	negated[]	= { "Negated",			"Asserted"		};
	static const char*	no[]		= { "No",				"Yes"			};
	static const char*	sampling[]	= { "Burst",			"Continuous"	};
	static const char*	twos[]		= { "Twos Compliment",	"Offset Binary"	};

	SHOW_FIELD( 0,  0, 1, aim,		"AI Mode"			);
	SHOW_FIELD( 1,  1, 1, sampling,	"Sampling"			);
	SHOW_FIELD( 3,  2, 1, range,	"AO Range"			);
	SHOW_FIELD( 4,  4, 1, NULL,		"Reserved"			);
	SHOW_FIELD( 5,  5, 1, twos,		"Data Format"		);
	SHOW_FIELD( 6,  6, 1, NULL,		"Reserved"			);
	SHOW_FIELD( 7,  7, 1, negated,	"AI SW Sync"		);
	SHOW_FIELD(10,  8, 1, irq,		"IRQ Select"		);
	SHOW_FIELD(11, 11, 1, negated,	"IRQ Status"		);
	SHOW_FIELD(15, 12, 1, NULL,		"Reserved"			);
	SHOW_FIELD(18, 16, 1, last,		"AI Last Channel"	);
	SHOW_FIELD(19, 19, 1, NULL,		"Reserved"			);
	SHOW_FIELD(20, 20, 1, no,		"AI Ready"			);
	SHOW_FIELD(21, 21, 1, negated,	"AI Trigger"		);
	SHOW_FIELD(22, 22, 1, coupling,	"AI Coupling"		);
	SHOW_FIELD(23, 23, 1, no,		"AI Buffer Empty"	);
	SHOW_FIELD(24, 24, 1, no,		"AI Buffer Full"	);
	SHOW_FIELD(25, 25, 1, clear,	"AI Threshold Sts"	);
	SHOW_FIELD(26, 26, 1, clk_src,	"AO Clock Source"	);
	SHOW_FIELD(27, 27, 1, no,		"AO Clock Ready"	);
	SHOW_FIELD(28, 28, 1, negated,	"AO Trigger"		);
	SHOW_FIELD(29, 29, 1, async,	"AO Clock Mode"		);
	SHOW_FIELD(30, 30, 1, no,		"AO Connect"		);
	SHOW_FIELD(31, 31, 1, negated,	"Initialize"		);
	return(0);
}



//*****************************************************************************
static int _diopr_decode(int fd, int supported, u32 value, int width)
{
	static const char*	input[]	= { "Input",		"Output"	};
	static const char*	zero[]	= { "0 (Clear)",	"1 (Set)"	};

	SHOW_FIELD( 7,  0, 1, NULL,		"I/O Data"			);
	SHOW_FIELD( 8,  8, 1, zero,		"Dedicated Input"	);
	SHOW_FIELD( 9,  9, 1, zero,		"Dedicated Output"	);
	SHOW_FIELD(10, 10, 1, input,	"Data Direction"	);
	SHOW_FIELD(31, 11, 1, NULL,		"Reserved"			);
	return(0);
}



//*****************************************************************************
static int _ocr_decode(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD(15,  0, 1, NULL,	"Data"		);
	SHOW_FIELD(31, 16, 1, NULL,	"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _idbr_decode(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD(23,  0, 1, NULL,	"Data"			);
	SHOW_FIELD(26, 24, 1, NULL,	"Channel Tag"	);
	SHOW_FIELD(31, 27, 1, NULL,	"Reserved"		);
	return(0);
}



//*****************************************************************************
static int _irar_decode(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD( 9,  0, 1, NULL,	"Nvco"		);
	SHOW_FIELD(15, 10, 1, NULL,	"Reserved"	);
	SHOW_FIELD(25, 16, 1, NULL,	"Nref"		);
	SHOW_FIELD(31, 26, 1, NULL,	"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _irdr_decode(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD( 5, 0, 1, NULL,	"Ndiv"		);
	SHOW_FIELD(31, 6, 1, NULL,	"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _ibcr_decode(int fd, int supported, u32 value, int width)
{
	static const char*	size[]	=
	{
		"16-Bits",
		"18-Bits",
		"20-Bits",
		"24-Bits"
	};

	static const char*	disabled[]	= { "No (disabled)",	"Yes (Enabled)"	};
	static const char*	negated[]	= { "Negated",			"Asserted"		};
	static const char*	no[]		= { "No",				"Yes"			};

	SHOW_FIELD(17,  0, 1, NULL,		"Buffer Threshold"	);
	SHOW_FIELD(18, 18, 1, disabled,	"Input Enable"		);
	SHOW_FIELD(19, 19, 1, negated,	"Buffer Clear"		);
	SHOW_FIELD(21, 20, 1, size,		"Data Width"		);
	SHOW_FIELD(23, 22, 1, NULL,		"Reserved"			);
	SHOW_FIELD(24, 24, 1, no,		"Overflow"			);
	SHOW_FIELD(25, 25, 1, no,		"Underflow"			);
	SHOW_FIELD(31, 26, 1, NULL,		"Reserved"			);
	return(0);
}



//*****************************************************************************
static int _ibsr_decode(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD(18,  0, 1, NULL,	"Samples"	);
	SHOW_FIELD(31, 19, 1, NULL,	"Reserved"	);
	return(0);
}



//*****************************************************************************
static int _bcfgr_decode(int fd, int supported, u32 value, int width)
{
	static const char*	volt[]	=
	{
		"+-10V",
		"+-5V",
		"+-2.5V",
		"RESERVED"
	};

	static const char*	ai_qty[]	= { "4",			"6"			};
	static const char*	ao_qty[]	= { "0",			"4"			};
	static const char*	filter[]	= { "270KHz",		"Custom"	};
	static const char*	temp[]		= { "Commercial",	"Extended"	};

	SHOW_FIELD(15,  0, 1, NULL,		"Firmware Revision"		);
	SHOW_FIELD(16, 16, 1, ai_qty,	"AI Channels"			);
	SHOW_FIELD(17, 17, 1, ao_qty,	"AO Channels"			);
	SHOW_FIELD(19, 18, 1, volt,		"AI Voltage Range"		);
	SHOW_FIELD(20, 20, 1, filter,	"Image Filter"			);
	SHOW_FIELD(21, 21, 1, temp,		"Temperature Range"		);
	SHOW_FIELD(31, 22, 1, NULL,		"Reserved"				);
	return(0);
}



//*****************************************************************************
static int _ordr_decode(int fd, int supported, u32 value, int width)
{
	SHOW_FIELD(23,  0, 1, NULL,	"Nrate"		);
	SHOW_FIELD(31, 24, 1, NULL,	"Reserved"	);
	return(0);
}



// variables ******************************************************************

static gsc_reg_def_t	_gsc[]	=
{
	{ _GSC_REG(BCTLR),	0,	_bctlr_decode,	"Board Control Register"			},
	{ _GSC_REG(DIOPR),	0,	_diopr_decode,	"Digital I/O Port Register"			},
	{ _GSC_REG(OC0R),	0,	_ocr_decode,	"Output Channel 0 Register"			},
	{ _GSC_REG(OC1R),	0,	_ocr_decode,	"Output Channel 1 Register"			},
	{ _GSC_REG(OC2R),	0,	_ocr_decode,	"Output Channel 2 Register"			},
	{ _GSC_REG(OC3R),	0,	_ocr_decode,	"Output Channel 3 Register"			},
	{ _GSC_REG(IDBR),	0,	_idbr_decode,	"Input Data Buffer Register"		},
	{ _GSC_REG(IRAR),	0,	_irar_decode,	"Input Rate Assignment Register"	},
	{ _GSC_REG(IRDR),	0,	_irdr_decode,	"Input Rate Divisor Register"		},
	{ _GSC_REG(IBCR),	0,	_ibcr_decode,	"Input Buffer Control Register"		},
	{ _GSC_REG(IBSR),	0,	_ibsr_decode,	"Input Buffer Size Register"		},
	{ _GSC_REG(BCFGR),	0,	_bcfgr_decode,	"Board Configuration Register"		},
	{ _GSC_REG(ORDR),	0,	_ordr_decode,	"Output Rate Divider Register"		},
	{ NULL, 0, 0, 0, 0, NULL	}
};



//*****************************************************************************
static const gsc_reg_def_t* _find_reg(u32 reg, const gsc_reg_def_t* list)
{
	const gsc_reg_def_t*	def	= NULL;
	int						i;

	for (i = 0; list[i].name; i++)
	{
		if (reg == list[i].reg)
		{
			def	= &list[i];
			break;
		}
	}

	return(def);
}



/******************************************************************************
*
*	Function:	dsi6ln4ao_reg_get_def_id
*
*	Purpose:
*
*		Retrieve the register definition structure given the register id.
*
*	Arguments:
*
*		reg		The id of the register to access.
*
*	Returned:
*
*		NULL	The register id wasn't found.
*		else	A pointer to the register definition.
*
******************************************************************************/

const gsc_reg_def_t* dsi6ln4ao_reg_get_def_id(u32 reg)
{
	const gsc_reg_def_t*	def;

	def	= _find_reg(reg, _gsc);
	return(def);
}



/******************************************************************************
*
*	Function:	dsi6ln4ao_reg_get_def_index
*
*	Purpose:
*
*		Retrieve the register definition structure based on an index.
*
*	Arguments:
*
*		index	The index of the register to access.
*
*	Returned:
*
*		NULL	The index doesn't correspond to a known register.
*		else	A pointer to the register definition.
*
******************************************************************************/

const gsc_reg_def_t* dsi6ln4ao_reg_get_def_index(int index)
{
	const gsc_reg_def_t*	def;

	if (index < 0)
		def	= NULL;
	else if (index >= (SIZEOF_ARRAY(_gsc) - 1))
		def	= NULL;
	else
		def	= &_gsc[index];

	return(def);
}



/******************************************************************************
*
*	Function:	dsi6ln4ao_reg_get_desc
*
*	Purpose:
*
*		Retrieve the description of the specified register.
*
*	Arguments:
*
*		reg		The register whose description is desired.
*
*	Returned:
*
*		!NULL	The register's name.
*
******************************************************************************/

const char* dsi6ln4ao_reg_get_desc(u32 reg)
{
	const gsc_reg_def_t*	def;
	const char*				desc;

	def	= _find_reg(reg, _gsc);

	if (def)
		desc	= def->desc;
	else
		desc	= "UNKNOWN";

	return(desc);
}



/******************************************************************************
*
*	Function:	dsi6ln4ao_reg_get_name
*
*	Purpose:
*
*		Retrieve the name of the specified register.
*
*	Arguments:
*
*		reg		The register whose name is desired.
*
*	Returned:
*
*		!NULL	The register's name.
*
******************************************************************************/

const char* dsi6ln4ao_reg_get_name(u32 reg)
{
	const gsc_reg_def_t*	def;
	const char*				name;

	def	= _find_reg(reg, _gsc);

	if (def)
		name	= def->name;
	else
		name	= "UNKNOWN";

	return(name);
}



/******************************************************************************
*
*	Function:	dsi6ln4ao_reg_list
*
*	Purpose:
*
*		List the GSC registers and their values.
*
*	Arguments:
*
*		fd		The handle to access the device.
*
*		detail	List the register details?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int dsi6ln4ao_reg_list(int fd, int detail)
{
	int	errs;

	errs	= gsc_reg_list(fd, _gsc, detail, dsi6ln4ao_reg_read);
	return(errs);
}


