// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/irq_sel.c $
// $Rev: 51458 $
// $Date: 2022-08-04 11:13:02 -0500 (Thu, 04 Aug 2022) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_irq_sel
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI6LN4AO_IOCTL_IRQ_SEL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	dsi6ln4ao_irq_sel(int fd, int index, int verbose, s32 set, s32* get)
{
	char	buf[128];
	int		errs;
	int		ret;

	if (verbose)
		gsc_label_index("IRQ Selection", index);

	ret		= dsi6ln4ao_ioctl(fd, DSI6LN4AO_IOCTL_IRQ_SEL, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "INVALID: %ld", (long) set);
			break;

		case DSI6LN4AO_IRQ_INIT_DONE:

			strcpy(buf, "Initialize Done");
			break;

		case DSI6LN4AO_IRQ_AI_READY_L2H:

			strcpy(buf, "AI Ready Low-to-High");
			break;

		case DSI6LN4AO_IRQ_AI_BUF_THR_L2H:

			strcpy(buf, "AI Buffer Threshold Low-to-High");
			break;

		case DSI6LN4AO_IRQ_AI_BUF_THR_H2L:

			strcpy(buf, "AI Buffer Threshold High-to-Low");
			break;

		case DSI6LN4AO_IRQ_AI_BUF_ERROR:

			strcpy(buf, "Ai Buffer Overrun or Underrun");
			break;

		case DSI6LN4AO_IRQ_AO_CLOCK_DONE:

			strcpy(buf, "AO Clock Done");
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


