// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/ioctl.c $
// $Rev: 53777 $
// $Date: 2023-09-28 12:51:48 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_ioctl_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device IOCTL call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		request	The IOCTL service to request.
*
*		arg		The argument for the IOCTL service.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi6ln4ao_ioctl_util(int fd, int index, int verbose, int request, void* arg)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("IOCTL", index);

	ret		= dsi6ln4ao_ioctl(fd, request, arg);
	errs	= (ret < 0) ? 1 : 0;

	if (verbose == 0)
		;
	else if (errs)
		printf("FAIL <---  (#%d)\n", (int) OS_IOCTL_INDEX_DECODE(request));
	else
		printf("PASS  (#%d)\n", (int) OS_IOCTL_INDEX_DECODE(request));

	return(errs);
}


