// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/gpio_rx.c $
// $Rev: 53777 $
// $Date: 2023-09-28 12:51:48 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_gpio_rx
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI6LN4AO_IOCTL_GPIO_RX service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	dsi6ln4ao_gpio_rx(int fd, int index, int verbose, s32* get)
{
	char	buf[64];
	int		errs;
	int		ret;
	s32		set;

	if (verbose)
		gsc_label_index("DIO Port Read", index);

	ret		= dsi6ln4ao_ioctl(fd, DSI6LN4AO_IOCTL_GPIO_RX, &set);
	errs	= ret ? 1 : 0;
	sprintf(buf, "0x%03lX", (long) set);

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


