// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/config_dio.c $
// $Rev: 53777 $
// $Date: 2023-09-28 12:51:48 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_config_dio
*
*	Purpose:
*
*		Configure the basic services.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		dir		The DIO port direction.
*
*		output	The initial output value for all 9 possible outputs.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	dsi6ln4ao_config_dio(int fd, int index, int verbose, s32 dir, s32 output)
{
	int	errs;

	if (verbose)
	{
		gsc_label_index("DIO Configuration", index);
		printf("\n");
		gsc_label_level_inc();
	}

	// Settings must be applied after the initialization call!

	dir		|= output;	// Combines initial output value.

	// Setting the direction also updates the output pins. This includes
	// the Dedicated Output and the 8 port pins, if set as outputs.
	errs	= dsi6ln4ao_gpio_dir(fd, index, verbose, dir, NULL);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


