// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/config_ai.c $
// $Rev: 53777 $
// $Date: 2023-09-28 12:51:48 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_config_ai
*
*	Purpose:
*
*		Configure the basic services.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	dsi6ln4ao_config_ai(int fd, int index, int verbose, int fsamp)
{
	int	errs	= 0;
	s32	nvco	= 0;
	s32	nref	= 0;
	s32	ndiv	= 0;
	s32	qty		= 6;

	if (verbose)
	{
		gsc_label_index("AI Configuration", index);
		printf("\n");
		gsc_label_level_inc();
	}

	errs	+= dsi6ln4ao_initialize			(fd, index, verbose);

	// Settings must be applied after the initialization call!

	errs	+= dsi6ln4ao_query				(fd, index, verbose, DSI6LN4AO_QUERY_AI_RANGE,		NULL);
	errs	+= dsi6ln4ao_ai_coupling		(fd, index, verbose, DSI6LN4AO_AI_COUPLING_AC,		NULL);
	errs	+= dsi6ln4ao_ai_mode			(fd, index, verbose, DSI6LN4AO_AI_MODE_DIFF,		NULL);

	errs	+= dsi6ln4ao_query				(fd, index, verbose, DSI6LN4AO_QUERY_AI_CHAN_QTY,	&qty);
	errs	+= dsi6ln4ao_ai_chan_last		(fd, index, verbose, qty - 1,						NULL);

	errs	+= dsi6ln4ao_ai_data_width		(fd, index, verbose, DSI6LN4AO_AI_DATA_WIDTH_16,	NULL);
	errs	+= dsi6ln4ao_ai_sampling		(fd, index, verbose, DSI6LN4AO_AI_SAMPLING_CONT,	NULL);
	errs	+= dsi6ln4ao_ai_thresh			(fd, index, verbose, 0x20000,						NULL);
	errs	+= dsi6ln4ao_data_format		(fd, index, verbose, DSI6LN4AO_DATA_FORMAT_OFF_BIN,	NULL);
	errs	+= dsi6ln4ao_rx_io_mode			(fd, index, verbose, GSC_IO_MODE_PIO,				NULL);
	errs	+= dsi6ln4ao_rx_io_overflow		(fd, index, verbose, DSI6LN4AO_IO_OVERFLOW_CHECK,	NULL);
	errs	+= dsi6ln4ao_rx_io_timeout		(fd, index, verbose, DSI6LN4AO_IO_TIMEOUT_DEFAULT,	NULL);
	errs	+= dsi6ln4ao_rx_io_underflow	(fd, index, verbose, DSI6LN4AO_IO_UNDERFLOW_CHECK,	NULL);

	errs	+= dsi6ln4ao_fsamp_ai_compute	(fd, index, verbose, fsamp, 1, &nvco, &nref, &ndiv,	NULL);
	errs	+= dsi6ln4ao_ai_ndiv			(fd, index, verbose, ndiv,							NULL);
	errs	+= dsi6ln4ao_ai_nref			(fd, index, verbose, nref,							NULL);
	errs	+= dsi6ln4ao_ai_nvco			(fd, index, verbose, nvco,							NULL);

	errs	+= dsi6ln4ao_ai_sync			(fd, index, verbose);
	errs	+= dsi6ln4ao_ai_buf_enable		(fd, index, verbose, DSI6LN4AO_AI_BUF_ENABLE_YES,	NULL);

	errs	+= dsi6ln4ao_fsamp_ai_report_all(fd, index, verbose,								NULL);

	// Settings affecting the sample rate or voltage range must generally
	// be applied before autocalibration.
	// Refer to the board user manual for clarification.

	// The 24DSI6LN4AO doesn't support autocalibration capabilities so no
	// such call is being made. If the feature was supported, the call
	// would be placced here.

	// Interrupt selections should be applied after autocalibration as the
	// driver overwrites the current selection to detect the Autocalibration
	// Done interrupt. If an application intends to detect the Autocalibration
	// Done interrupt, then the interrupt selection may be made beforehand.
	errs	+= dsi6ln4ao_irq_sel			(fd, index, verbose, DSI6LN4AO_IRQ_INIT_DONE,		NULL);

	// The final step is to clear the buffer. This service clears the FIFO and
	// resets the overflow and underflow status bits.
	errs	+= dsi6ln4ao_ai_buf_clear		(fd, index, verbose);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


