// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/ai_sampling.c $
// $Rev: 51458 $
// $Date: 2022-08-04 11:13:02 -0500 (Thu, 04 Aug 2022) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_ai_sampling
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI6LN4AO_IOCTL_AI_SAMPLING service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi6ln4ao_ai_sampling(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	s32			ret;

	if (verbose)
		gsc_label_index("AI Sampling Mode", index);

	ret		= dsi6ln4ao_ioctl(fd, DSI6LN4AO_IOCTL_AI_SAMPLING, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs	= 1;
			ptr		= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case DSI6LN4AO_AI_SAMPLING_BURST:

			ptr	= "Burst";
			break;

		case DSI6LN4AO_AI_SAMPLING_CONT:

			ptr	= "Continuous";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


