// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/utils/ai_buf_status.c $
// $Rev: 53777 $
// $Date: 2023-09-28 12:51:48 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi6ln4ao_ai_buf_status
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI6LN4AO_IOCTL_AI_BUF_STATUS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi6ln4ao_ai_buf_status(int fd, int index, int verbose, s32* get)
{
	char	buf[128];
	int		errs;
	int		ret;
	s32		set;

	if (verbose)
		gsc_label_index("AI Buffer Status", index);

	ret		= dsi6ln4ao_ioctl(fd, DSI6LN4AO_IOCTL_AI_BUF_STATUS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "INVALID: %ld", (long) set);
			break;

		case DSI6LN4AO_AI_BUF_STATUS_EMPTY:

			strcpy(buf, "Empty");
			break;

		case DSI6LN4AO_AI_BUF_STATUS_AE:

			strcpy(buf, "Almost Empty");
			break;

		case DSI6LN4AO_AI_BUF_STATUS_AF:

			strcpy(buf, "Almost Full");
			break;

		case DSI6LN4AO_AI_BUF_STATUS_FULL:

			strcpy(buf, "Full");
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


