// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/wait/wait_main.c $
// $Rev: 51471 $
// $Date: 2022-08-04 11:23:12 -0500 (Thu, 04 Aug 2022) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _perform_dma(int fd)
{
	u32	buf[1024];
	int	errs	= 0;
	s32	ndiv;
	s32	nref;
	s32	nvco;
	int	ret;

	errs	+= dsi6ln4ao_ai_coupling		(fd, -1, 0, DSI6LN4AO_AI_COUPLING_AC,		NULL);
	errs	+= dsi6ln4ao_ai_mode			(fd, -1, 0, DSI6LN4AO_AI_MODE_DIFF,			NULL);
	errs	+= dsi6ln4ao_ai_chan_last		(fd, -1, 0, 3,								NULL);
	errs	+= dsi6ln4ao_ai_data_width		(fd, -1, 0, DSI6LN4AO_AI_DATA_WIDTH_16,		NULL);
	errs	+= dsi6ln4ao_ai_sampling		(fd, -1, 0, DSI6LN4AO_AI_SAMPLING_CONT,		NULL);
	errs	+= dsi6ln4ao_rx_io_mode			(fd, -1, 0, GSC_IO_MODE_BMDMA,				NULL);
	errs	+= dsi6ln4ao_rx_io_overflow		(fd, -1, 0, DSI6LN4AO_IO_OVERFLOW_IGNORE,	NULL);
	errs	+= dsi6ln4ao_rx_io_timeout		(fd, -1, 0, DSI6LN4AO_IO_TIMEOUT_DEFAULT,	NULL);
	errs	+= dsi6ln4ao_rx_io_underflow	(fd, -1, 0, DSI6LN4AO_IO_UNDERFLOW_IGNORE,	NULL);

	errs	+= dsi6ln4ao_fsamp_ai_compute	(fd, -1, 0, 200000, 1, &nvco, &nref, &ndiv,	NULL);
	errs	+= dsi6ln4ao_ai_ndiv			(fd, -1, 0, ndiv,							NULL);
	errs	+= dsi6ln4ao_ai_nref			(fd, -1, 0, nref,							NULL);
	errs	+= dsi6ln4ao_ai_nvco			(fd, -1, 0, nvco,							NULL);

	errs	+= dsi6ln4ao_ai_buf_over		(fd, -1, 0, DSI6LN4AO_AI_BUF_OVER_CLEAR,	NULL);
	errs	+= dsi6ln4ao_ai_buf_under		(fd, -1, 0, DSI6LN4AO_AI_BUF_UNDER_CLEAR,	NULL);
	errs	+= dsi6ln4ao_ai_buf_enable		(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_YES,	NULL);

	ret		= dsi6ln4ao_read(fd, buf, sizeof(buf));
	errs	+= (ret == sizeof(buf)) ? 0 : 1;
	return(errs);
}



//*****************************************************************************
int wait_main_dma_test(int fd)
{
	int	errs;

	errs	= _perform_dma(fd);
	return(errs);
}



//*****************************************************************************
int wait_main_gsc_test(int fd)
{
	int	errs	= 0;

	errs	+= dsi6ln4ao_ai_buf_enable	(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_NO,	NULL);
	errs	+= dsi6ln4ao_ai_buf_clear	(fd, -1, 0);
	errs	+= dsi6ln4ao_irq_sel		(fd, -1, 0, DSI6LN4AO_IRQ_AI_BUF_ERROR,	NULL);
	errs	+= dsi6ln4ao_reg_read		(fd, -1, 0, DSI6LN4AO_GSC_IDBR,			NULL);
	return(errs);
}



//*****************************************************************************
int wait_main_pci_test(int fd)
{
	int	errs;

	errs	= _perform_dma(fd);
	return(errs);
}


