// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/wait/wait_io.c $
// $Rev: 51471 $
// $Date: 2022-08-04 11:23:12 -0500 (Thu, 04 Aug 2022) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	int		io_fd;
static	sem_t	sem_enter;
static	sem_t	sem_exit;



//*****************************************************************************
static int _read_thread(void* arg)
{
	char	buf[1024];

	sem_post(&sem_enter);
	dsi6ln4ao_rx_io_overflow	(io_fd, -1, 0, DSI6LN4AO_IO_OVERFLOW_IGNORE, NULL);
	dsi6ln4ao_rx_io_underflow	(io_fd, -1, 0, DSI6LN4AO_IO_UNDERFLOW_IGNORE, NULL);
	dsi6ln4ao_read(io_fd, buf, sizeof(buf));
	sem_post(&sem_exit);
	return(0);
}



//*****************************************************************************
int wait_io_rx_abort_test(int fd)
{
	s32			aborted	= 0;
	int			errs	= 0;
	os_thread_t	thread;

	errs	+= dsi6ln4ao_initialize	(fd, -1, 0);
	errs	+= dsi6ln4ao_rx_io_timeout(fd, -1, 0, 15, NULL);

	if (errs == 0)
	{
		io_fd	= fd;
		sem_init(&sem_enter, 0, 0);
		sem_init(&sem_exit, 0, 0);
		memset(&thread, 0, sizeof(thread));
		errs	+= os_thread_create(&thread, "I/O Abort", _read_thread, NULL);

		if (errs == 0)
		{
			// Wait for the thread to become waiting.
			sem_wait(&sem_enter);

			// Cause the I/O to abort.
			errs	+= dsi6ln4ao_rx_io_abort	(fd, -1, 0, &aborted);

			// Wait for the resumed thread to run.
			sem_wait(&sem_exit);

			errs	+= os_thread_destroy(&thread);
		}
	}

	return(errs);
}



//*****************************************************************************
int wait_io_rx_done_test(int fd)
{
	char	buf[512];
	int		errs	= 0;

	errs	+= dsi6ln4ao_initialize		(fd, -1, 0);
	errs	+= dsi6ln4ao_rx_io_timeout	(fd, -1, 0, 1, NULL);
	dsi6ln4ao_read(fd, buf, sizeof(buf));
	return(errs);
}



//*****************************************************************************
int wait_io_rx_error_test(int fd)
{
	int	errs;

	errs	= dsi6ln4ao_initialize(fd, -1, 0);
	dsi6ln4ao_read(fd, NULL, 3);
	return(errs);
}



//*****************************************************************************
int wait_io_rx_timeout_test(int fd)
{
	char	buf[1024];
	int		errs	= 0;
	int		ret;

	errs	+= dsi6ln4ao_ai_buf_enable	(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_NO, NULL);
	errs	+= dsi6ln4ao_ai_buf_clear	(fd, -1, 0);
	errs	+= dsi6ln4ao_rx_io_overflow	(fd, -1, 0, DSI6LN4AO_IO_OVERFLOW_IGNORE, NULL);
	errs	+= dsi6ln4ao_rx_io_timeout	(fd, -1, 0, 1, NULL);
	errs	+= dsi6ln4ao_rx_io_underflow(fd, -1, 0, DSI6LN4AO_IO_UNDERFLOW_IGNORE, NULL);

	ret		= dsi6ln4ao_read(fd, buf, sizeof(buf));

	if (ret != 0)
	{
		errs++;
		printf(" --- no timeout: ret %d --- ", ret);
	}

	os_sleep_ms(1000);
	return(errs);
}


