// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/wait/wait_gsc.c $
// $Rev: 51471 $
// $Date: 2022-08-04 11:23:12 -0500 (Thu, 04 Aug 2022) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



//*****************************************************************************
int wait_gsc_ai_buf_error_over_test(int fd)
{
	int	errs	= 0;
	s32	ndiv;
	s32	nref;
	s32	nvco;

	errs	+= dsi6ln4ao_ai_buf_enable		(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_YES,	NULL);
	errs	+= dsi6ln4ao_irq_sel			(fd, -1, 0, DSI6LN4AO_IRQ_AI_BUF_ERROR,		NULL);

	errs	+= dsi6ln4ao_fsamp_ai_compute	(fd, -1, 0, 200000, 1, &nvco, &nref, &ndiv,	NULL);
	errs	+= dsi6ln4ao_ai_ndiv			(fd, -1, 0, ndiv,							NULL);
	errs	+= dsi6ln4ao_ai_nref			(fd, -1, 0, nref,							NULL);
	errs	+= dsi6ln4ao_ai_nvco			(fd, -1, 0, nvco,							NULL);
	os_sleep_ms(1000);	// Wait for settling and overflow.
	return(errs);
}



//*****************************************************************************
int wait_gsc_ai_buf_error_under_test(int fd)
{
	int	errs	= 0;

	errs	+= dsi6ln4ao_irq_sel		(fd, -1, 0, DSI6LN4AO_IRQ_AI_BUF_ERROR,	NULL);

	errs	+= dsi6ln4ao_ai_buf_enable	(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_NO,	NULL);
	errs	+= dsi6ln4ao_ai_buf_clear	(fd, -1, 0);
	errs	+= dsi6ln4ao_reg_read		(fd, -1, 0, DSI6LN4AO_GSC_IDBR,			NULL);
	return(errs);
}



//*****************************************************************************
int wait_gsc_ai_buf_thr_h2l_test(int fd)
{
	int	errs	= 0;
	s32	ndiv;
	s32	nref;
	s32	nvco;

	errs	+= dsi6ln4ao_ai_buf_enable		(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_YES,	NULL);
	errs	+= dsi6ln4ao_ai_thresh			(fd, -1, 0, 100,							NULL);

	errs	+= dsi6ln4ao_fsamp_ai_compute	(fd, -1, 0, 200000, 1, &nvco, &nref, &ndiv,	NULL);
	errs	+= dsi6ln4ao_ai_ndiv			(fd, -1, 0, ndiv,							NULL);
	errs	+= dsi6ln4ao_ai_nref			(fd, -1, 0, nref,							NULL);
	errs	+= dsi6ln4ao_ai_nvco			(fd, -1, 0, nvco,							NULL);
	os_sleep_ms(1000);	// Wait for settling.

	errs	+= dsi6ln4ao_ai_buf_enable		(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_NO,		NULL);

	errs	+= dsi6ln4ao_irq_sel			(fd, -1, 0, DSI6LN4AO_IRQ_AI_BUF_THR_H2L,	NULL);

	errs	+= dsi6ln4ao_ai_buf_clear		(fd, -1, 0);
	return(errs);
}



//*****************************************************************************
int wait_gsc_ai_buf_thr_l2h_test(int fd)
{
	int	errs	= 0;
	s32	ndiv;
	s32	nref;
	s32	nvco;

	errs	+= dsi6ln4ao_ai_buf_enable		(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_NO,		NULL);
	errs	+= dsi6ln4ao_ai_buf_clear		(fd, -1, 0);

	errs	+= dsi6ln4ao_fsamp_ai_compute	(fd, -1, 0, 200000, 1, &nvco, &nref, &ndiv,	NULL);
	errs	+= dsi6ln4ao_ai_ndiv			(fd, -1, 0, ndiv,							NULL);
	errs	+= dsi6ln4ao_ai_nref			(fd, -1, 0, nref,							NULL);
	errs	+= dsi6ln4ao_ai_nvco			(fd, -1, 0, nvco,							NULL);

	errs	+= dsi6ln4ao_irq_sel			(fd, -1, 0, DSI6LN4AO_IRQ_AI_BUF_THR_L2H,	NULL);

	errs	+= dsi6ln4ao_ai_thresh			(fd, -1, 0, 100,							NULL);
	errs	+= dsi6ln4ao_ai_buf_enable		(fd, -1, 0, DSI6LN4AO_AI_BUF_ENABLE_YES,	NULL);
	os_sleep_ms(100);

	return(errs);
}



//*****************************************************************************
int wait_gsc_ai_ready_l2h_test(int fd)
{
	int	errs	= 0;
	s32	ndiv;
	s32	nref;
	s32	nvco;

	errs	+= dsi6ln4ao_irq_sel			(fd, -1, 0, DSI6LN4AO_IRQ_AI_READY_L2H,		NULL);

	errs	+= dsi6ln4ao_fsamp_ai_compute	(fd, -1, 0, 200000, 1, &nvco, &nref, &ndiv,	NULL);
	errs	+= dsi6ln4ao_ai_ndiv			(fd, -1, 0, ndiv,							NULL);
	errs	+= dsi6ln4ao_ai_nref			(fd, -1, 0, nref,							NULL);
	errs	+= dsi6ln4ao_ai_nvco			(fd, -1, 0, nvco,							NULL);

	errs	+= dsi6ln4ao_fsamp_ai_compute	(fd, -1, 0, 2000, 1, &nvco, &nref, &ndiv,	NULL);
	errs	+= dsi6ln4ao_ai_ndiv			(fd, -1, 0, ndiv,							NULL);
	errs	+= dsi6ln4ao_ai_nref			(fd, -1, 0, nref,							NULL);
	errs	+= dsi6ln4ao_ai_nvco			(fd, -1, 0, nvco,							NULL);
	return(errs);
}



//*****************************************************************************
int wait_gsc_ao_clock_done_test(int fd)
{
	int	errs	= 0;
	s32	nrate;

	errs	+= dsi6ln4ao_irq_sel		(fd, -1, 0, DSI6LN4AO_IRQ_AO_CLOCK_DONE,	NULL);

	errs	+= dsi6ln4ao_fclk_ao_compute(fd, -1, 0, 100, &nrate,					NULL);
	errs	+= dsi6ln4ao_ao_nrate		(fd, -1, 0, nrate,							NULL);
	errs	+= dsi6ln4ao_ao_clk_mode	(fd, -1, 0, DSI6LN4AO_AO_CLK_MODE_SYNC,		NULL);
	os_sleep_ms(150);
	return(errs);
}



//*****************************************************************************
int wait_gsc_init_done_test(int fd)
{
	int	errs;

	errs	= dsi6ln4ao_initialize(fd, -1, 0);
	return(errs);
}


