// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/wait/perform.c $
// $Rev: 53790 $
// $Date: 2023-09-28 12:56:50 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



// data types *****************************************************************

typedef struct
{
	const char*	title;
	u32			main;
	u32			gsc;
	u32			io;
	int			(*callback)(int fd);
} options_t;



// variables ******************************************************************

static const options_t options[]	=
{
	// title					main								gsc		io	callback
	{ "PCI",					GSC_WAIT_MAIN_PCI,					0,		0,	wait_main_pci_test					},
	{ "DMA0/DMA1",				GSC_WAIT_MAIN_DMA0 |
								GSC_WAIT_MAIN_DMA1,					0,		0,	wait_main_dma_test					},
	{ "GSC",					GSC_WAIT_MAIN_GSC,					0,		0,	wait_main_gsc_test					},

	// title					main	gsc									io	callback
	{ "Init Done",				0,		DSI6LN4AO_WAIT_GSC_INIT_DONE,		0,	wait_gsc_init_done_test				},
	{ "AI Ready L->H",			0,		DSI6LN4AO_WAIT_GSC_AI_READY_L2H,	0,	wait_gsc_ai_ready_l2h_test			},
	{ "AI Threshold L->H",		0,		DSI6LN4AO_WAIT_GSC_AI_BUF_THR_L2H,	0,	wait_gsc_ai_buf_thr_l2h_test		},
	{ "AI Threshold H->L",		0,		DSI6LN4AO_WAIT_GSC_AI_BUF_THR_H2L,	0,	wait_gsc_ai_buf_thr_h2l_test		},
	{ "AI Buf Error (Over)",	0,		DSI6LN4AO_WAIT_GSC_AI_BUF_ERROR,	0,	wait_gsc_ai_buf_error_over_test		},
	{ "AI Buf Error (Under)",	0,		DSI6LN4AO_WAIT_GSC_AI_BUF_ERROR,	0,	wait_gsc_ai_buf_error_under_test	},
	{ "AO Clock Done",			0,		DSI6LN4AO_WAIT_GSC_AO_CLOCK_DONE,	0,	wait_gsc_ao_clock_done_test			},

	// title					main	gsc	io									callback
	{ "I/O Rx Abort",			0,		0,	DSI6LN4AO_WAIT_IO_RX_ABORT,			wait_io_rx_abort_test				},
	{ "I/O Rx Done",			0,		0,	DSI6LN4AO_WAIT_IO_RX_DONE,			wait_io_rx_done_test				},
	{ "I/O Rx Error",			0,		0,	DSI6LN4AO_WAIT_IO_RX_ERROR,			wait_io_rx_error_test				},
	{ "I/O Rx Timeout",			0,		0,	DSI6LN4AO_WAIT_IO_RX_TIMEOUT,		wait_io_rx_timeout_test				},
	{ NULL }
};



//*****************************************************************************
int perform_tests(const args_t* args)
{
	s32	ao_qty	= 0;
	int	errs	= 0;
	int	i;

	errs	+= dsi6ln4ao_query(args->fd, -1, 1, DSI6LN4AO_QUERY_AO_CHAN_QTY,&ao_qty);

	for (i = 0; options[i].title; i++)
	{
		gsc_label(options[i].title);

		if ((ao_qty == 0) && (options[i].gsc == DSI6LN4AO_WAIT_GSC_AO_CLOCK_DONE))
		{
			printf("SKIPPED  (No output channels present.)\n");
			continue;
		}

		errs	+= service_test(args->fd, options[i].main, options[i].gsc, options[i].io, options[i].callback);
	}

	return(errs);
}


