// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/wait/main.h $
// $Rev: 53790 $
// $Date: 2023-09-28 12:56:50 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/timeb.h>

#include "24dsi6ln4ao_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for device to access.

	// Device Settings

} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);

int	service_test(int fd, u32 main, u32 gsc, u32 io, int (*callback)(int fd));

int	wait_gsc_ai_buf_error_over_test(int fd);
int	wait_gsc_ai_buf_error_under_test(int fd);
int	wait_gsc_ai_buf_thr_h2l_test(int fd);
int	wait_gsc_ai_buf_thr_l2h_test(int fd);
int	wait_gsc_ai_ready_l2h_test(int fd);
int	wait_gsc_ao_clock_done_test(int fd);
int	wait_gsc_init_done_test(int fd);

int	wait_io_rx_abort_test(int fd);
int	wait_io_rx_done_test(int fd);
int	wait_io_rx_error_test(int fd);
int	wait_io_rx_timeout_test(int fd);

int	wait_main_dma_test(int fd);
int	wait_main_gsc_test(int fd);
int	wait_main_pci_test(int fd);



#endif
