// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/savedata/main.h $
// $Rev: 53788 $
// $Date: 2023-09-28 12:56:15 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "24dsi6ln4ao_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))
#define	CHAN_TAG_EXCLUDE		1
#define	CHAN_TAG_ONLY			2



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	chan_tag;		// Channel tag processing.
	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	decimal;		// Save data in decimal format? Default is hex.
	s32	force_save;		// Save data even if there are errors?
	s32	fsamp;			// Desired sample rate.
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	repeat;			// repeat data retrieval this many times
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for device to access.

	// Device Settings

	s32	ai_mode;		// Analog Input Mode
	s32	io_mode;
} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);



#endif
