// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/rxrate/perform.c $
// $Rev: 53786 $
// $Date: 2023-09-28 12:55:44 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M	(1024L * 1024L)	// size of driver's transfer buffer



// variables ******************************************************************

static	u8	_data[_1M];



//*****************************************************************************
static int _configuration(const args_t* args)
{
	int	errs	= 0;
	s32	fsamp;

	errs	+= dsi6ln4ao_query			(args->fd, -1, 1, DSI6LN4AO_QUERY_AI_FSAMP_MAX, &fsamp);
	errs	+= dsi6ln4ao_config_ai		(args->fd, -1, 1, fsamp);
	errs	+= dsi6ln4ao_rx_io_mode		(args->fd, -1, 1, args->io_mode, NULL);
	errs	+= dsi6ln4ao_rx_io_overflow	(args->fd, -1, 1, DSI6LN4AO_IO_OVERFLOW_IGNORE, NULL);
	errs	+= dsi6ln4ao_rx_io_underflow(args->fd, -1, 1, DSI6LN4AO_IO_UNDERFLOW_IGNORE, NULL);

	return(errs);
}



//*****************************************************************************
static int _rate_test(const args_t* args, long get)
{
	struct timeval	begin;
	int				errs	= 0;
	long			got;
	long long		limit	= (long long) args->rx_mb * 1000000L;
	struct timeval	minimum;
	struct timeval	now;
	long long		sps;
	long long		total	= 0;
	long			us;

	gsc_label("Reading");

	gettimeofday(&begin, NULL);
	minimum.tv_sec	= begin.tv_sec + args->seconds;
	minimum.tv_usec	= begin.tv_usec;

	for (;;)
	{
		got	= dsi6ln4ao_read(args->fd, _data, get);

		if (got < 0)
		{
			errs++;
			printf("FAIL <--- (read");
			printf(", total so far %lld", total);
			printf(", requested %ld bytes", (long) get);
			printf(", error %ld)\n", got);
			break;
		}

		gettimeofday(&now, NULL);
		total	+= got;

		if (total < limit)
			continue;

		if (now.tv_sec < minimum.tv_sec)
			continue;

		if ((now.tv_sec == minimum.tv_sec) && (now.tv_usec < minimum.tv_usec))
			continue;

		us	= (now.tv_sec - begin.tv_sec) * 1000000L
			+ (now.tv_usec - begin.tv_usec);
		sps	= (total * 10000000L / 4 / us + 5) / 10;

		printf(	"PASS  (");
		gsc_label_long_comma(total / 4);
		printf(" Samples, %ld.%06ld Seconds, ", us / 1000000, us % 1000000);
		gsc_label_long_comma(sps);
		printf(" S/S)\n");
		break;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	long	get		= sizeof(_data);

	errs	+= _configuration(args);

	gsc_label ("Read Rate");
	printf("(%d second minimum, %ld MB minimum)\n", args->seconds, (long) args->rx_mb);
	gsc_label_level_inc();

	errs	+= dsi6ln4ao_ai_buf_clear	(args->fd, -1, 1);
	errs	+= dsi6ln4ao_ai_buf_over	(args->fd, -1, 1, DSI6LN4AO_AI_BUF_OVER_CLEAR, NULL);
	errs	+= dsi6ln4ao_ai_buf_under	(args->fd, -1, 1, DSI6LN4AO_AI_BUF_UNDER_CLEAR, NULL);

	errs	+= _rate_test(args, get);

	errs	+= dsi6ln4ao_ai_buf_over	(args->fd, -1, 1, DSI6LN4AO_AI_BUF_OVER_TEST, NULL);
	errs	+= dsi6ln4ao_ai_buf_under	(args->fd, -1, 1, DSI6LN4AO_AI_BUF_UNDER_TEST, NULL);

	gsc_label_level_dec();
	return(errs);
}



