// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/id/perform.c $
// $Rev: 53783 $
// $Date: 2023-09-28 12:54:43 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _input_modes(void)
{
	gsc_label("Input Modes");
	printf("AC/DC Coupling, Differential, Single Ended\n");
}



//*****************************************************************************
static void _output_modes(void)
{
	gsc_label("Output Modes");
	printf("Singe Ended, Unbufferred\n");
}



//*****************************************************************************
static void _voltage_ranges(void)
{
	gsc_label("AI Voltage Ranges");
	printf("+-10V, +-5V, +-2.5V (Factory Configured)\n");

	gsc_label("AO Voltage Ranges");
	printf("+-10V, +-5V, +-2.5V\n");
}



//*****************************************************************************
static void _clocking_sources(void)
{
	gsc_label("Input Clocking Sources");
	printf("Internal, Software\n");

	gsc_label("Output Clocking Sources");
	printf("Internal, External, Software, Automatic\n");
}



//*****************************************************************************
static void _digital_io(void)
{
	gsc_label("Digital I/O");
	printf("8-bit Bidirectional, 1-bit In, 1-bit Out\n");
}



//*****************************************************************************
static int _id_device_reg(const args_t* args)
{
	int						errs;
	gsc_reg_def_t			list[2]	= { { NULL }, { NULL } };
	const gsc_reg_def_t*	ptr;

	printf("\n");
	ptr	= dsi6ln4ao_reg_get_def_id(DSI6LN4AO_GSC_BCFGR);

	if (ptr)
	{
		list[0]	= ptr[0];
		errs	= gsc_reg_list(args->fd, list, 1, dsi6ln4ao_reg_read);
	}
	else
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. dsi6ln4ao_reg_get_def_id, DSI6LN4AO_GSC_BCFGR)\n",
				__LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _register_map(const args_t* args)
{
	int	errs;

	printf("\n");
	errs	= dsi6ln4ao_reg_list(args->fd, 0);
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("Device Features");
	printf("\n");

	gsc_label_level_inc();

	_input_modes();
	_output_modes();
	_voltage_ranges();
	_clocking_sources();
	_digital_io();

	for (i = 0; i < DSI6LN4AO_QUERY_LAST; i++)
		errs	+= dsi6ln4ao_query(args->fd, -1, 1, i, NULL);

	gsc_label_level_dec();

	errs	+= _id_device_reg(args);
	errs	+= _register_map(args);
	printf("\n");

	return(errs);
}


