// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/fsamp/perform.c $
// $Rev: 53782 $
// $Date: 2023-09-28 12:54:28 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	FILE_NAME_OVERALL		"fsamp_overall.txt"
#define	FILE_NAME_OPTIMAL		"fsamp_optimal.txt"
#define	LIMIT_MAX(v,max)		(((v) > (max)) ? (max) : (v))
#define	LIMIT_MIN(v,min)		(((v) < (min)) ? (min) : (v))
#define	LIMIT_RANGE(v,min,max)	(LIMIT_MIN((LIMIT_MAX((v),(max))),(min)))



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int			errs	= 0;
	FILE*		file	= NULL;
	s32			fsamp;
	s32			max		= args->fsamp;
	s32			min		= args->fsamp;
	const char*	name	= args->optimal ? FILE_NAME_OPTIMAL : FILE_NAME_OVERALL;
	float		rate;

	gsc_label("Fsamp Computation");

	if (args->save)
		printf("Saving to file: %s", name);

	printf("\n");
	gsc_label_level_inc();

	errs	+= dsi6ln4ao_query(args->fd, -1, 0, DSI6LN4AO_QUERY_AI_FSAMP_MAX, &max);
	errs	+= dsi6ln4ao_query(args->fd, -1, 0, DSI6LN4AO_QUERY_AI_FSAMP_MIN, &min);

	if (args->range == 0)
	{
		min	= LIMIT_RANGE(args->fsamp, min, max);
		max	= min;
	}

	if (args->save)
	{
		file	= fopen(name, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", name);
			errs	= 1;
		}
		else
		{
			fprintf(file, "# 24DSI6LN4AO Fsamp Rates - %s\n", args->optimal ? "Optimal" : "Overall");
			fprintf(file, "# Request  Produced\n");
			fprintf(file, "# =======  ==========\n");
		}
	}

	for (fsamp = min; fsamp <= max; fsamp++)
	{
		errs	+= dsi6ln4ao_fsamp_ai_compute(args->fd, -1, 1, fsamp, args->optimal, NULL, NULL, NULL, &rate);

		if (file)
			fprintf(file, "%9ld  %10.3f\n", (long) fsamp, (float) rate);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}


