// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/fclk/perform.c $
// $Rev: 53781 $
// $Date: 2023-09-28 12:54:13 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	FILE_NAME				"fclk.txt"
#define	LIMIT_MAX(v,max)		(((v) > (max)) ? (max) : (v))
#define	LIMIT_MIN(v,min)		(((v) < (min)) ? (min) : (v))
#define	LIMIT_RANGE(v,min,max)	(LIMIT_MIN((LIMIT_MAX((v),(max))),(min)))



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int			errs	= 0;
	FILE*		file	= NULL;
	s32			fclk;
	s32			max		= args->fclk;
	s32			min		= args->fclk;
	const char*	name	= FILE_NAME;
	float		rate;

	gsc_label("Fclk Computation");

	if (args->save)
		printf("Saving to file: %s", name);

	printf("\n");
	gsc_label_level_inc();

	errs	+= dsi6ln4ao_query(args->fd, -1, 0, DSI6LN4AO_QUERY_AO_FCLK_MAX, &max);
	errs	+= dsi6ln4ao_query(args->fd, -1, 0, DSI6LN4AO_QUERY_AO_FCLK_MIN, &min);

	if (args->range == 0)
	{
		min	= LIMIT_RANGE(args->fclk, min, max);
		max	= min;
	}

	if (args->save)
	{
		file	= fopen(name, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", name);
			errs	= 1;
		}
		else
		{
			fprintf(file, "# 24DSI6LN4AO Fclk Rates\n");
			fprintf(file, "# Request  Produced\n");
			fprintf(file, "# =======  ==========\n");
		}
	}

	for (fclk = min; fclk <= max; fclk++)
	{
		errs	+= dsi6ln4ao_fclk_ao_compute(args->fd, -1, 1, fclk, NULL, &rate);

		if (file)
			fprintf(file, "%9ld  %10.3f\n", (long) fclk, (float) rate);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}


