// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/din/perform.c $
// $Rev: 53779 $
// $Date: 2023-09-28 12:53:40 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	DASH_BITS		0x10101010
#define	DIO_BITS		10
#define	NIBBLE_BITS		0x11111110



//*****************************************************************************
static int _config(const args_t* args)
{
	int	errs	= 0;

	gsc_label("Configuration");
	printf("\n");
	gsc_label_level_inc();

	errs	+= dsi6ln4ao_initialize	(args->fd, -1, 1);
	errs	+= dsi6ln4ao_gpio_dir	(args->fd, -1, 1, DSI6LN4AO_GPIO_DIR_INPUT, NULL);
	errs	+= dsi6ln4ao_gpio_tx	(args->fd, -1, 1, 0x3FF, NULL);

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static void _output_header(void)
{
	printf("\n");
	printf("  Seq   GPIO In                                     \n");
	printf("  No.   OI 7654 3210  Time Stamp      Delta         \n");
	printf("  ====  ============  ==============  ==============\n");
}



//*****************************************************************************
static int _monitor(const args_t* args)
{
	u32				bit;
	int				count	= 0;
	long long		delta;
	int				errs	= 0;
	int				i;
	s32				last	= -1;
	time_t			now;
	time_t			t_limit;
	os_time_ns_t	t0;
	os_time_ns_t	ts;
	os_time_ns_t	ts_last;
	s32				value;

	gsc_label("Digital Input");
	printf("\n");
	gsc_label_level_inc();

	os_time_get_ns(&t0);
	os_time_get_ns(&ts);

	_output_header();
	t_limit	= time(NULL) + args->seconds + 1;

	for (; errs == 0;)
	{
		errs	+= dsi6ln4ao_gpio_rx(args->fd, -1, 0, &value);

		if ((count <= 0) || (value != last))
		{
			ts_last	= ts;
			os_time_get_ns(&ts);

			if (count <= 0)
			{
				os_time_get_ns(&t0);
				ts		= t0;
				ts_last	= t0;
			}

			count++;
			printf("  %-4d  ", count);

			for (i = DIO_BITS - 1; i >= 0; i--)
			{
				bit	= 0x1 << i;
				printf("%s", (value & bit) ? "1" : "0");

				if (bit & DASH_BITS)
					printf("-");
				else if (bit & NIBBLE_BITS)
					printf(" ");
			}

			delta	= (1000000000LL * ts.tv_sec + ts.tv_nsec)
					- (1000000000LL * t0.tv_sec + t0.tv_nsec);
			printf("  %4lld.%09lld", delta / 1000000000, delta % 1000000000);

			delta	= (1000000000LL * ts.tv_sec + ts.tv_nsec)
					- (1000000000LL * ts_last.tv_sec + ts_last.tv_nsec);
			printf("  %4lld.%09lld", delta / 1000000000, delta % 1000000000);

			printf("\n");
			fflush(stdout);
			last	= value;
		}

		now	= time(NULL);

		if (now >= t_limit)
			break;

		if (args->ms_wait)
			os_sleep_ms(args->ms_wait);
	}

	printf("\n");
	gsc_label("Status");
	printf("%s\n", errs ? "FAIL <---" : "PASS");

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;

	errs	+= _config(args);
	errs	+= _monitor(args);

	return(errs);
}


