// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/samples/aout/main.h $
// $Rev: 53778 $
// $Date: 2023-09-28 12:53:21 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>

#include "24dsi6ln4ao_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	chan_0;
	s32	chan_1;
	s32	chan_2;
	s32	chan_3;
	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	decimal;		// Save teh data in decimal format?
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	save_txt;		// Save the pattern to a text file.
	s32	seconds;		// Output data for this long.
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for device to access.

	// Device Settings

	s32	synchronous;	// Use synchronous clocking?
} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);



#endif
