// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/include/24dsi6ln4ao_utils.h $
// $Rev: 53774 $
// $Date: 2023-09-28 12:46:38 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Utilities: header file

#ifndef	__24DSI6LN4AO_UTILS_H__
#define	__24DSI6LN4AO_UTILS_H__

#include "24dsi6ln4ao_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	dsi6ln4ao_close_util(int fd, int index, int verbose);
int dsi6ln4ao_init_util	(int verbose);
int dsi6ln4ao_ioctl_util(int fd, int index, int verbose, int request, void* arg);
int	dsi6ln4ao_open_util	(int device, int share, int index, int verbose, int* fd);
int	dsi6ln4ao_read_util	(int fd, int index, int verbose, void* dst, size_t bytes, size_t* got);

// IOCTL utility services
int	dsi6ln4ao_ai_buf_clear		(int fd, int index, int verbose);								// DSI6LN4AO_IOCTL_AI_BUF_CLEAR
int	dsi6ln4ao_ai_buf_enable		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_BUF_ENABLE
int	dsi6ln4ao_ai_buf_level		(int fd, int index, int verbose,		  s32* get);			// DSI6LN4AO_IOCTL_AI_BUF_LEVEL
int	dsi6ln4ao_ai_buf_over		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_BUF_OVER
int	dsi6ln4ao_ai_buf_status		(int fd, int index, int verbose,		  s32* get);			// DSI6LN4AO_IOCTL_AI_BUF_STATUS
int	dsi6ln4ao_ai_buf_under		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_BUF_UNDER
int	dsi6ln4ao_ai_chan_last		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_CHAN_LAST
int	dsi6ln4ao_ai_coupling		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_COUPLING
int	dsi6ln4ao_ai_data_width		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_DATA_WIDTH
int	dsi6ln4ao_ai_mode			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_MODE
int	dsi6ln4ao_ai_ndiv			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_NDIV
int	dsi6ln4ao_ai_nref			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_NREF
int	dsi6ln4ao_ai_nvco			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_NVCO
int	dsi6ln4ao_ai_ready			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_READY
int	dsi6ln4ao_ai_sampling		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_SAMPLING
int	dsi6ln4ao_ai_sync			(int fd, int index, int verbose);								// DSI6LN4AO_IOCTL_AI_SYNC
int	dsi6ln4ao_ai_thresh			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AI_THRESH
int	dsi6ln4ao_ai_thresh_sts		(int fd, int index, int verbose,		  s32* get);			// DSI6LN4AO_IOCTL_AI_THRESH_STS
int	dsi6ln4ao_ai_trigger		(int fd, int index, int verbose);								// DSI6LN4AO_IOCTL_AI_TRIGGER
int	dsi6ln4ao_ao_ch_0_write		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_CH_0_WRITE
int	dsi6ln4ao_ao_ch_1_write		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_CH_1_WRITE
int	dsi6ln4ao_ao_ch_2_write		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_CH_2_WRITE
int	dsi6ln4ao_ao_ch_3_write		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_CH_3_WRITE
int	dsi6ln4ao_ao_clk_mode		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_CLK_MODE
int	dsi6ln4ao_ao_clk_src		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_CLK_SRC
int	dsi6ln4ao_ao_enable			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_ENABLE
int	dsi6ln4ao_ao_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_NRATE
int	dsi6ln4ao_ao_range			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_RANGE
int	dsi6ln4ao_ao_ready			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_AO_READY
int	dsi6ln4ao_ao_trigger		(int fd, int index, int verbose);								// DSI6LN4AO_IOCTL_AO_TRIGGER
int	dsi6ln4ao_data_format		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_DATA_FORMAT
int	dsi6ln4ao_gpio_dir			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_GPIO_DIR
int	dsi6ln4ao_gpio_rx			(int fd, int index, int verbose,		  s32* get);			// DSI6LN4AO_IOCTL_GPIO_RX
int	dsi6ln4ao_gpio_tx			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_GPIO_TX
int	dsi6ln4ao_initialize		(int fd, int index, int verbose);								// DSI6LN4AO_IOCTL_INITIALIZE
int	dsi6ln4ao_irq_sel			(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_IRQ_SEL
int	dsi6ln4ao_query				(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_QUERY
int	dsi6ln4ao_reg_mod			(int fd, int index, int verbose, u32 reg, u32 set, u32 mask);	// DSI6LN4AO_IOCTL_REG_MOD
int	dsi6ln4ao_reg_read			(int fd, int index, int verbose, u32 reg, u32* get);			// DSI6LN4AO_IOCTL_REG_READ
int	dsi6ln4ao_reg_write			(int fd, int index, int verbose, u32 reg, u32 set);				// DSI6LN4AO_IOCTL_REG_WRITE
int	dsi6ln4ao_rx_io_abort		(int fd, int index, int verbose,		  s32* get);			// DSI6LN4AO_IOCTL_RX_IO_ABORT
int	dsi6ln4ao_rx_io_mode		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_RX_IO_MODE
int	dsi6ln4ao_rx_io_overflow	(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_RX_IO_OVERFLOW
int	dsi6ln4ao_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_RX_IO_TIMEOUT
int	dsi6ln4ao_rx_io_underflow	(int fd, int index, int verbose, s32 set, s32* get);			// DSI6LN4AO_IOCTL_RX_IO_UNDERFLOW
int	dsi6ln4ao_wait_cancel		(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI6LN4AO_IOCTL_WAIT_CANCEL
int	dsi6ln4ao_wait_event		(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI6LN4AO_IOCTL_WAIT_EVENT
int	dsi6ln4ao_wait_status		(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI6LN4AO_IOCTL_WAIT_STATUS


// Auxiliary utility services

int	dsi6ln4ao_config_ai				(int fd, int index, int verbose, int fsamp);
int	dsi6ln4ao_config_ao				(int fd, int index, int verbose, int fclk);
int	dsi6ln4ao_config_dio			(int fd, int index, int verbose, s32 dir, s32 output);
int dsi6ln4ao_fsamp_ai_compute		(int fd, int index, int verbose, int fsamp, int optimal, s32* nvco, s32* nref, s32* ndiv, float* rate);
int dsi6ln4ao_fsamp_ai_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int dsi6ln4ao_fsamp_ai_report_all	(int fd, int index, int verbose, s32* fsamp);
int	dsi6ln4ao_fclk_ao_compute		(int fd, int index, int verbose, int fclk, s32* nrate, float* rate);
int	dsi6ln4ao_fclk_ao_report		(int fd, int index, int verbose, s32* fclk);
int dsi6ln4ao_id_device				(int fd, int index, int verbose);

int	dsi6ln4ao_count_boards			(int verbose, s32* get);
int dsi6ln4ao_reg_list				(int fd, int detail);

const gsc_reg_def_t*	dsi6ln4ao_reg_get_def_id	(u32 reg);
const gsc_reg_def_t*	dsi6ln4ao_reg_get_def_index	(int index);
const char*				dsi6ln4ao_reg_get_desc		(u32 reg);
const char*				dsi6ln4ao_reg_get_name		(u32 reg);



#endif
