// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/driver/24dsi6ln4ao.h $
// $Rev: 53791 $
// $Date: 2023-09-28 12:58:13 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Device Driver: header file

#ifndef	__24DSI6LN4AO_H__
#define	__24DSI6LN4AO_H__

#include "gsc_common.h"
#include "gsc_pci9056.h"



// macros *********************************************************************

#define	DSI6LN4AO_BASE_NAME					"24dsi6ln4ao"

// IOCTL command codes
#define	DSI6LN4AO_IOCTL_REG_READ			OS_IOCTL_RW( 0, 12, gsc_reg_t)
#define	DSI6LN4AO_IOCTL_REG_WRITE			OS_IOCTL_W ( 1, 12, gsc_reg_t)
#define	DSI6LN4AO_IOCTL_REG_MOD				OS_IOCTL_W ( 2, 12, gsc_reg_t)
#define	DSI6LN4AO_IOCTL_QUERY				OS_IOCTL_RW( 3,  4, s32)
#define	DSI6LN4AO_IOCTL_INITIALIZE			OS_IOCTL   ( 4)
#define	DSI6LN4AO_IOCTL_AI_BUF_CLEAR		OS_IOCTL   ( 5)
#define	DSI6LN4AO_IOCTL_AI_BUF_ENABLE		OS_IOCTL_RW( 6,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_BUF_LEVEL		OS_IOCTL_R ( 7,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_BUF_OVER			OS_IOCTL_RW( 8,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_BUF_STATUS		OS_IOCTL_R ( 9,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_BUF_UNDER		OS_IOCTL_RW(10,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_CHAN_LAST		OS_IOCTL_RW(11,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_COUPLING			OS_IOCTL_RW(12,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_DATA_WIDTH		OS_IOCTL_RW(13,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_MODE				OS_IOCTL_RW(14,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_NDIV				OS_IOCTL_RW(15,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_NREF				OS_IOCTL_RW(16,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_NVCO				OS_IOCTL_RW(17,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_READY			OS_IOCTL_RW(18,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_SAMPLING			OS_IOCTL_RW(19,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_SYNC				OS_IOCTL   (20)
#define	DSI6LN4AO_IOCTL_AI_THRESH			OS_IOCTL_RW(21,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_THRESH_STS		OS_IOCTL_R (22,  4, s32)
#define	DSI6LN4AO_IOCTL_AI_TRIGGER			OS_IOCTL   (23)
#define	DSI6LN4AO_IOCTL_AO_CH_0_WRITE		OS_IOCTL_RW(24,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_CH_1_WRITE		OS_IOCTL_RW(25,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_CH_2_WRITE		OS_IOCTL_RW(26,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_CH_3_WRITE		OS_IOCTL_RW(27,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_CLK_MODE			OS_IOCTL_RW(28,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_CLK_SRC			OS_IOCTL_RW(29,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_ENABLE			OS_IOCTL_RW(30,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_NRATE			OS_IOCTL_RW(31,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_RANGE			OS_IOCTL_RW(32,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_READY			OS_IOCTL_RW(33,  4, s32)
#define	DSI6LN4AO_IOCTL_AO_TRIGGER			OS_IOCTL   (34)
#define	DSI6LN4AO_IOCTL_DATA_FORMAT			OS_IOCTL_RW(35,  4, s32)
#define	DSI6LN4AO_IOCTL_GPIO_DIR			OS_IOCTL_RW(36,  4, s32)
#define	DSI6LN4AO_IOCTL_GPIO_RX				OS_IOCTL_R (37,  4, s32)
#define	DSI6LN4AO_IOCTL_GPIO_TX				OS_IOCTL_RW(38,  4, s32)
#define	DSI6LN4AO_IOCTL_IRQ_SEL				OS_IOCTL_RW(39,  4, s32)
#define	DSI6LN4AO_IOCTL_RX_IO_ABORT			OS_IOCTL_R (40,  4, s32)
#define	DSI6LN4AO_IOCTL_RX_IO_DMA_THRESH	OS_IOCTL_R (41,  4, s32)
#define	DSI6LN4AO_IOCTL_RX_IO_MODE			OS_IOCTL_RW(42,  4, s32)
#define	DSI6LN4AO_IOCTL_RX_IO_OVERFLOW		OS_IOCTL_R (43,  4, s32)
#define	DSI6LN4AO_IOCTL_RX_IO_PIO_THRESH	OS_IOCTL_R (44,  4, s32)
#define	DSI6LN4AO_IOCTL_RX_IO_TIMEOUT		OS_IOCTL_RW(45,  4, s32)
#define	DSI6LN4AO_IOCTL_RX_IO_UNDERFLOW		OS_IOCTL_R (46,  4, s32)
#define	DSI6LN4AO_IOCTL_WAIT_CANCEL			OS_IOCTL_RW(47, 28, gsc_wait_t)
#define	DSI6LN4AO_IOCTL_WAIT_EVENT			OS_IOCTL_RW(48, 28, gsc_wait_t)
#define	DSI6LN4AO_IOCTL_WAIT_STATUS			OS_IOCTL_RW(49, 28, gsc_wait_t)


//*****************************************************************************
// DSI6LN4AO_IOCTL_REG_READ
// DSI6LN4AO_IOCTL_REG_WRITE
// DSI6LN4AO_IOCTL_REG_MOD
//
#define	DSI6LN4AO_REG_ENCODE(s,o)	GSC_REG_ENCODE(GSC_REG_TYPE_BAR2,(s),(o))
// Parameter:	gsc_reg_t*
#define	DSI6LN4AO_GSC_BCTLR			DSI6LN4AO_REG_ENCODE(4,0x00)// Board Control Register
#define	DSI6LN4AO_GSC_DIOPR			DSI6LN4AO_REG_ENCODE(4,0x04)// Digital I/O Port Register
#define	DSI6LN4AO_GSC_OC0R			DSI6LN4AO_REG_ENCODE(4,0x08)// Output Ch 0 Register
#define	DSI6LN4AO_GSC_OC1R			DSI6LN4AO_REG_ENCODE(4,0x0C)// Output Ch 1 Register
#define	DSI6LN4AO_GSC_OC2R			DSI6LN4AO_REG_ENCODE(4,0x10)// Output Ch 2 Register
#define	DSI6LN4AO_GSC_OC3R			DSI6LN4AO_REG_ENCODE(4,0x14)// Output Ch 3 Register
#define	DSI6LN4AO_GSC_IDBR			DSI6LN4AO_REG_ENCODE(4,0x18)// Input Data Buffer Register
#define	DSI6LN4AO_GSC_IRAR			DSI6LN4AO_REG_ENCODE(4,0x1C)// Input Rate Assignment Register
#define	DSI6LN4AO_GSC_IRDR			DSI6LN4AO_REG_ENCODE(4,0x20)// Input Rate Divisor Register
#define	DSI6LN4AO_GSC_IBCR			DSI6LN4AO_REG_ENCODE(4,0x24)// Input Buffer Control Register
#define	DSI6LN4AO_GSC_IBSR			DSI6LN4AO_REG_ENCODE(4,0x28)// Input Buffer Size Register
#define	DSI6LN4AO_GSC_BCFGR			DSI6LN4AO_REG_ENCODE(4,0x34)// Board Configuration Register
#define	DSI6LN4AO_GSC_ORDR			DSI6LN4AO_REG_ENCODE(4,0x38)// Output Rate Divisor Register

//*****************************************************************************
// DSI6LN4AO_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	DSI6LN4AO_QUERY_AI_CHAN_MAX,	// The maximum number of possible input channels.
	DSI6LN4AO_QUERY_AI_CHAN_QTY,	// The number of installed input channels. BCFGR.D16
	DSI6LN4AO_QUERY_AI_FIFO_SIZE,	// Input FIFO depth in 32-bit samples
	DSI6LN4AO_QUERY_AI_FILTER,		// The installed input filter option. BCFGR.D20
	DSI6LN4AO_QUERY_AI_FREF,		// The AI master clock frequqncy.
	DSI6LN4AO_QUERY_AI_FSAMP_MAX,	// The maximum input sample rate per channel.
	DSI6LN4AO_QUERY_AI_FSAMP_MIN,	// The minimum input sample rate per channel.
	DSI6LN4AO_QUERY_AI_NDIV_MAX,	// Maximum input rate generator Ndiv value.
	DSI6LN4AO_QUERY_AI_NDIV_MIN,	// Minimum input rate generator Ndiv value.
	DSI6LN4AO_QUERY_AI_NREF_MAX,	// Maximum input rate generator Nref value.
	DSI6LN4AO_QUERY_AI_NREF_MAX_OPT,// Maximum input optimal rate generator Nref value.
	DSI6LN4AO_QUERY_AI_NREF_MIN,	// Minimum input rate generator Nref value.
	DSI6LN4AO_QUERY_AI_NVCO_MAX,	// Maximum input rate generator Nvco value.
	DSI6LN4AO_QUERY_AI_NVCO_MAX_OPT,// Maximum input optimal rate generator Nvco value.
	DSI6LN4AO_QUERY_AI_NVCO_MIN,	// Minimum input rate generator Nvco value.
	DSI6LN4AO_QUERY_AI_RANGE,		// The installed input voltage range option. BCFGR.D18-D19
	DSI6LN4AO_QUERY_AO_CHAN_MAX,	// The maximum number of possible output channels.
	DSI6LN4AO_QUERY_AO_CHAN_QTY,	// The number of installed output channels. BCFGR.D17
	DSI6LN4AO_QUERY_AO_FCLK_MAX,	// The maximum output clock rate.
	DSI6LN4AO_QUERY_AO_FCLK_MIN,	// The minimum output clock rate.
	DSI6LN4AO_QUERY_AO_FREF,		// The AO master clock frequqncy.
	DSI6LN4AO_QUERY_AO_NRATE_MAX,	// Maximum output rate generator Nrate value.
	DSI6LN4AO_QUERY_AO_NRATE_MIN,	// Minimum output rate generator Nrate value.
	DSI6LN4AO_QUERY_COUNT,			// How many query options are supported?
	DSI6LN4AO_QUERY_DEVICE_TYPE,	// Value from gsc_dev_type_t
	DSI6LN4AO_QUERY_INIT_MS,		// Max initialize period in ms.
	DSI6LN4AO_QUERY_TEMPERATURE,	// The temperature range option. BCFGR.D21
	DSI6LN4AO_QUERY_LAST			// The last query index number.
} dsi6ln4ao_query_t;

#define	DSI6LN4AO_IOCTL_QUERY_ERROR			(-1)

// DSI6LN4AO_QUERY_AI_FILTER
#define	DSI6LN4AO_AI_FILTER_CUSTOM			1
#define	DSI6LN4AO_AI_FILTER_270KHZ			0

// DSI6LN4AO_QUERY_AI_RANGE
#define	DSI6LN4AO_AI_RANGE_2_5				2	// +-2.5
#define	DSI6LN4AO_AI_RANGE_5				1	// +-5
#define	DSI6LN4AO_AI_RANGE_10				0	// +-10

// DSI6LN4AO_QUERY_TEMPERATURE
#define	DSI6LN4AO_TEMPERATURE_COM			0
#define	DSI6LN4AO_TEMPERATURE_EXT			1

//*****************************************************************************
// DSI6LN4AO_IOCTL_INITIALIZE				BCTLR D31
//
// Parameter:	None.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_BUF_CLEAR				IBCR D19
//
//	Parameter:	None.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_BUF_ENABLE			IBCR D18
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AI_BUF_ENABLE_NO			0
#define	DSI6LN4AO_AI_BUF_ENABLE_YES			1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_BUF_LEVEL				IBSR D0-D18
//
//	Parameter:	s32*
//		The value returned is from zero through 0x40000.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_BUF_OVER				IBCR D24
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
//		These values are passed to the service.
#define	DSI6LN4AO_AI_BUF_OVER_TEST			(-1)
#define	DSI6LN4AO_AI_BUF_OVER_CLEAR			1
//		These values are returned by the service.
#define	DSI6LN4AO_AI_BUF_OVER_NO			0
#define	DSI6LN4AO_AI_BUF_OVER_YES			1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_BUF_STATUS			BCTLR D23, D24, D25
//
//	Parameter:	s32*
//		One of the following values will be returned.
#define	DSI6LN4AO_AI_BUF_STATUS_EMPTY		1
#define	DSI6LN4AO_AI_BUF_STATUS_AE			2	// at or below threshold
#define	DSI6LN4AO_AI_BUF_STATUS_AF			3	// above threshold
#define	DSI6LN4AO_AI_BUF_STATUS_FULL		4

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_BUF_UNDER				IBCR D25
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
//		These values are passed to the service.
#define	DSI6LN4AO_AI_BUF_UNDER_TEST			(-1)
#define	DSI6LN4AO_AI_BUF_UNDER_CLEAR		1
//		These values are returned by the service.
#define	DSI6LN4AO_AI_BUF_UNDER_NO			0
#define	DSI6LN4AO_AI_BUF_UNDER_YES			1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_CHAN_LAST				BCTLR D16-D18
//
//	Parameter:	s32*
//		Pass in any valid value from zero to the 5 for 6 channel devices, zero
//		to 3 for 4 channel devices, or -1 to read the current setting.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_COUPLING				BCTLR D22
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AI_COUPLING_AC			0
#define	DSI6LN4AO_AI_COUPLING_DC			1	// Not recommended.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_DATA_WIDTH			IBCR D20-D21
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AI_DATA_WIDTH_16			0
#define	DSI6LN4AO_AI_DATA_WIDTH_18			1
#define	DSI6LN4AO_AI_DATA_WIDTH_20			2
#define	DSI6LN4AO_AI_DATA_WIDTH_24			3

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_MODE					BCTLR D0
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AI_MODE_SE				0
#define	DSI6LN4AO_AI_MODE_DIFF				1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_NDIV					IRDR D0-D5
//
//	Parameter:	s32*
//		Pass in any value from zero through 25, or
//		-1 to read the current setting.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_NREF					IRAR D16-D25
//
//	Parameter:	s32*
//		Pass in any value from 30 through 1000, or
//		-1 to read the current setting.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_NVCO					IRAR D0-D9
//
//	Parameter:	s32*
//		Pass in any value from 30 through 1000, or
//		-1 to read the current setting.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_READY					BCTLR D20
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
//		These values are passed to the service.
#define	DSI6LN4AO_AI_READY_TEST				(-1)
#define	DSI6LN4AO_AI_READY_WAIT				1
//		These values are returned by the service.
#define	DSI6LN4AO_AI_READY_NO				0
#define	DSI6LN4AO_AI_READY_YES				1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_SAMPLING				BCTLR D1
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AI_SAMPLING_BURST			0
#define	DSI6LN4AO_AI_SAMPLING_CONT			1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_SYNC					BCTLR D7
//
// Parameter:	None.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_THRESH			IBCR D0-D17
//
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is 0-0x3FFFF.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_THRESH_STS			BCTLR D25
//
//	Parameter:	s32*
//		This service returns one of the following options.
#define	DSI6LN4AO_AI_THRESH_STS_CLEAR		0
#define	DSI6LN4AO_AI_THRESH_STS_SET			1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AI_TRIGGER				BCTLR D21
//
// Parameter:	None.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AO_CH_0_WRITE			OC0R D0-D15
// DSI6LN4AO_IOCTL_AO_CH_1_WRITE			OC1R D0-D15
// DSI6LN4AO_IOCTL_AO_CH_2_WRITE			OC2R D0-D15
// DSI6LN4AO_IOCTL_AO_CH_3_WRITE			OC3R D0-D15
//
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		The valid range is 0-0xFFFF.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AO_CLK_MODE				BCTLR D29
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AO_CLK_MODE_ASYNC			0
#define	DSI6LN4AO_AO_CLK_MODE_SYNC			1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AO_CLK_SRC				BCTLR D26
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AO_CLK_SRC_INT			0
#define	DSI6LN4AO_AO_CLK_SRC_EXT			1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AO_ENABLE				BCTLR D30
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AO_ENABLE_NO				0
#define	DSI6LN4AO_AO_ENABLE_YES				1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AO_NRATE					ORDR D0-D23
//
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is xxxx-0xFFFFFF.

//*****************************************************************************
// DSI6LN4AO_IOCTL_AO_RANGE					BCTLR D2-D3
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_AO_RANGE_10V				0	// 0 or 1
#define	DSI6LN4AO_AO_RANGE_5V				2
#define	DSI6LN4AO_AO_RANGE_2_5V				3

//*****************************************************************************
// DSI6LN4AO_IOCTL_AO_READY					BCTLR D27
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
//		These values are passed to the service.
#define	DSI6LN4AO_AO_READY_TEST				(-1)
#define	DSI6LN4AO_AO_READY_WAIT				1
//		These values are returned by the service.
#define	DSI6LN4AO_AO_READY_NO				0
#define	DSI6LN4AO_AO_READY_YES				1

//*****************************************************************************
// DSI6LN4AO_IOCTL_AO_TRIGGER				BCTLR D28
//
// Parameter:	None.

//*****************************************************************************
// DSI6LN4AO_IOCTL_DATA_FORMAT				BCTLR D5
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_DATA_FORMAT_2S_COMP		0	// Twos Compliment
#define	DSI6LN4AO_DATA_FORMAT_OFF_BIN		1	// Offset Binary

//*****************************************************************************
// DSI6LN4AO_IOCTL_GPIO_DIR				DIOPR D10
//
//	Parameter:	s32*
//		Pass in any of the below options, or -1 to read the current setting.
//		If making the OUTPUT option, then also include the initial 8-bit output
//		port values.
#define	DSI6LN4AO_GPIO_DIR_INPUT		0
#define	DSI6LN4AO_GPIO_DIR_OUTPUT		1

//*****************************************************************************
// DSI6LN4AO_IOCTL_GPIO_RX				DIOPR D0-D9
//
//	Parameter:	s32*
//		The value returned will be from 0x000 to 0x3FF.

//*****************************************************************************
// DSI6LN4AO_IOCTL_GPIO_TX				DIOPR D0-D7, D9
//
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current port value.
//		The valid range is 0x000 to 0x3FF.
//		The DEDICATED INPUT bit (D8) is ignored.

//*****************************************************************************
// DSI6LN4AO_IOCTL_IRQ_SEL					BCTLR D8-D10, D11
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_IRQ_INIT_DONE				0
#define	DSI6LN4AO_IRQ_AI_READY_L2H			1
#define	DSI6LN4AO_IRQ_AI_BUF_THR_L2H		2
#define	DSI6LN4AO_IRQ_AI_BUF_THR_H2L		3
#define	DSI6LN4AO_IRQ_AI_BUF_ERROR			4
#define	DSI6LN4AO_IRQ_AO_CLOCK_DONE			7

//*****************************************************************************
// DSI6LN4AO_IOCTL_RX_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	DSI6LN4AO_IO_ABORT_NO				0
#define	DSI6LN4AO_IO_ABORT_YES				1

//*****************************************************************************
// DSI6LN4AO_IOCTL_RX_IO_DMA_THRESH			For testing purposes only.
//
//	Parameter:	s32*
//		Pass in any non-negative value, or
//		-1 to read the current setting.
#define	DSI6LN4AO_RX_IO_DMA_THRESH_DEF		18	// in samples, based on testing

//*****************************************************************************
// DSI6LN4AO_IOCTL_RX_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_IO_MODE_DEFAULT			GSC_IO_MODE_PIO

//*****************************************************************************
// DSI6LN4AO_IOCTL_RX_IO_OVERFLOW			software setting
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_IO_OVERFLOW_IGNORE		0
#define	DSI6LN4AO_IO_OVERFLOW_CHECK			1
#define	DSI6LN4AO_IO_OVERFLOW_DEFAULT		DSI6LN4AO_IO_OVERFLOW_CHECK

//*****************************************************************************
// DSI6LN4AO_IOCTL_RX_IO_PIO_THRESH			For testing purposes only.
//
//	Parameter:	s32*
//		Pass in any non-negative value, or
//		-1 to read the current setting.
#define	DSI6LN4AO_RX_IO_PIO_THRESH_DEF		14	// in samples, based on testing

//*****************************************************************************
// DSI6LN4AO_IOCTL_RX_IO_TIMEOUT (in seconds)
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	DSI6LN4AO_IO_TIMEOUT_DEFAULT		10
#define	DSI6LN4AO_IO_TIMEOUT_NO_SLEEP		0
#define	DSI6LN4AO_IO_TIMEOUT_MIN			0
#define	DSI6LN4AO_IO_TIMEOUT_MAX			GSC_IO_TIMEOUT_MAX
#define	DSI6LN4AO_IO_TIMEOUT_INFINITE		GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// DSI6LN4AO_IOCTL_RX_IO_UNDERFLOW			software setting
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	DSI6LN4AO_IO_UNDERFLOW_IGNORE		0
#define	DSI6LN4AO_IO_UNDERFLOW_CHECK		1
#define	DSI6LN4AO_IO_UNDERFLOW_DEFAULT		DSI6LN4AO_IO_UNDERFLOW_CHECK

//*****************************************************************************
// DSI6LN4AO_IOCTL_WAIT_CANCEL				all fields must be valid
// DSI6LN4AO_IOCTL_WAIT_EVENT				fields need not be valid
// DSI6LN4AO_IOCTL_WAIT_STATUS				fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc
#define	DSI6LN4AO_WAIT_GSC_INIT_DONE			0x0001
#define	DSI6LN4AO_WAIT_GSC_AI_READY_L2H			0x0002
#define	DSI6LN4AO_WAIT_GSC_AI_BUF_THR_L2H		0x0004
#define	DSI6LN4AO_WAIT_GSC_AI_BUF_THR_H2L		0x0008
#define	DSI6LN4AO_WAIT_GSC_AI_BUF_ERROR			0x0010
#define	DSI6LN4AO_WAIT_GSC_AO_CLOCK_DONE		0x0020
#define	DSI6LN4AO_WAIT_GSC_ALL					0x003F

// gsc_wait_t.alt flags
#define	DSI6LN4AO_WAIT_ALT_ALL					0x0000
// gsc_wait_t.io
#define	DSI6LN4AO_WAIT_IO_RX_ABORT				0x0001
#define	DSI6LN4AO_WAIT_IO_RX_DONE				0x0002
#define	DSI6LN4AO_WAIT_IO_RX_ERROR				0x0004
#define	DSI6LN4AO_WAIT_IO_RX_TIMEOUT			0x0008
#define	DSI6LN4AO_WAIT_IO_ALL					0x000F



#endif

