// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI6LN4AO/driver/irq.c $
// $Rev: 53791 $
// $Date: 2023-09-28 12:58:13 -0500 (Thu, 28 Sep 2023) $

// 24DSI6LN4AO: Device Driver: source file

#include "main.h"



//*****************************************************************************
void dev_irq_isr_local_handler(dev_data_t* dev)
{
	#define	BCTLR_IRQ_REQUEST	D11

	u32	bctlr;
	u32	req;

	bctlr	= os_reg_mem_rx_u32(NULL, dev->vaddr.gsc_bctlr_32);

	if (bctlr & BCTLR_IRQ_REQUEST)
	{
		// Clear the interrupt.
		bctlr	^= BCTLR_IRQ_REQUEST;
		os_reg_mem_tx_u32(NULL, dev->vaddr.gsc_bctlr_32, bctlr);

		// Resume any waiting threads.
		req	= GSC_FIELD_DECODE(bctlr, 10, 8);

		switch (req)
		{
			default:

				gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
				break;

			case DSI6LN4AO_IRQ_INIT_DONE:

				gsc_wait_resume_irq_gsc(dev, DSI6LN4AO_WAIT_GSC_INIT_DONE);
				break;

			case DSI6LN4AO_IRQ_AI_READY_L2H:

				gsc_wait_resume_irq_gsc(dev, DSI6LN4AO_WAIT_GSC_AI_READY_L2H);
				break;

			case DSI6LN4AO_IRQ_AI_BUF_THR_L2H:

				gsc_wait_resume_irq_gsc(dev, DSI6LN4AO_WAIT_GSC_AI_BUF_THR_L2H);
				break;

			case DSI6LN4AO_IRQ_AI_BUF_THR_H2L:

				gsc_wait_resume_irq_gsc(dev, DSI6LN4AO_WAIT_GSC_AI_BUF_THR_H2L);
				break;

			case DSI6LN4AO_IRQ_AI_BUF_ERROR:

				gsc_wait_resume_irq_gsc(dev, DSI6LN4AO_WAIT_GSC_AI_BUF_ERROR);
				break;

			case DSI6LN4AO_IRQ_AO_CLOCK_DONE:

				gsc_wait_resume_irq_gsc(dev, DSI6LN4AO_WAIT_GSC_AO_CLOCK_DONE);
				break;
		}
	}
	else
	{
		// We don't know the source of the interrupt.
		gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
	}
}



//*****************************************************************************
int dev_irq_create(dev_data_t* dev)
{
	int	ret;

	os_reg_mem_mx_u32(dev, dev->vaddr.gsc_bctlr_32, 0, D8 | D9 | D10);
	ret	= gsc_irq_create(dev);
	return(ret);
}



//*****************************************************************************
void dev_irq_destroy(dev_data_t* dev)
{
	if (dev->vaddr.gsc_bctlr_32)
		os_reg_mem_mx_u32(dev, dev->vaddr.gsc_bctlr_32, 0, D8 | D9 | D10);

	gsc_irq_destroy(dev);
}


