// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_wait_cancel.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_wait_cancel
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI20C500K_IOCTL_WAIT_CANCEL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		wait	This is the crieteria to use.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi20c500k_wait_cancel(int fd, int index, int verbose, gsc_wait_t* wait)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Wait Cancel", index);

	if (wait)
	{
		ret		= dsi20c500k_ioctl(fd, DSI20C500K_IOCTL_WAIT_CANCEL, wait);
		errs	= ret ? 1 : 0;

		if (verbose)
		{
			printf(	"%s  (%ld wait%s cancelled)\n",
					errs ? "FAIL <---" : "PASS",
					(long) wait->count,
					(wait->count == 1) ? "" : "s");
		}
	}
	else
	{
		errs	= 1;

		if (verbose)
			printf(	"FAIL <---  (NULL pointer)\n");
	}

	return(errs);
}


