// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_id.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	_id_device_pci
*
*	Purpose:
*
*		Identify the device using the PCI registers.
*
*	Arguments:
*
*		fd		The handle used to access the device.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

static int _id_device_pci(int fd)
{
	int	errs	= 0;
	u32	reg;

	gsc_label("Vendor ID");
	errs	+= dsi20c500k_reg_read(fd, -1, 0, GSC_PCI_9656_VIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Device ID");
	errs	+= dsi20c500k_reg_read(fd, -1, 0, GSC_PCI_9656_DIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x9656)
	{
		printf("(PCI9656)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Sub Vendor ID");
	errs	+= dsi20c500k_reg_read(fd, -1, 0, GSC_PCI_9656_SVID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Subsystem ID");
	errs	+= dsi20c500k_reg_read(fd, -1, 0, GSC_PCI_9656_SID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x3490)
	{
		printf("(24DSI20C500K)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	dsi20c500k_id_device
*
*	Purpose:
*
*		Identify the device.
*
*	Arguments:
*
*		fd		The handle to use to access the device.
*
*		index	The index of the device or -1 if we don't care.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int dsi20c500k_id_device(int fd, int index, int verbose)
{
	s32			device_type;
	int			errs;
	const char*	psz			= "";

	if (verbose)
		gsc_label_index("Device", index);

	errs	= dsi20c500k_query(fd, -1, 0, DSI20C500K_QUERY_DEVICE_TYPE, &device_type);

	if (errs)
	{
		if (verbose)
			printf("FAIL <---  (query error)\n");
	}
	else
	{
		switch (device_type)
		{
			default:

				errs	= 1;

				if (verbose)
				{
					printf(	"FAIL <---  (unexpected device type: %ld)",
							(long) device_type);
				}

				break;

			case GSC_DEV_TYPE_24DSI20C500K:	psz	= "24DSI20C500K";	break;
		}

		if ((verbose) && (errs == 0))
			printf("%s\n", psz);

		gsc_label_level_inc();

		errs	+= _id_device_pci(fd);

		gsc_label_level_dec();
	}

	return(errs);
}



