// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_dio_read.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_dio_read
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI20C500K_IOCTL_DIO_READ service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi20c500k_dio_read(int fd, int index, int verbose, s32* get)
{
	int	errs;
	int	ret;
	s32	set;

	if (verbose)
		gsc_label_index("Digital I/O Read", index);

	ret		= dsi20c500k_ioctl(fd, DSI20C500K_IOCTL_DIO_READ, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (0x%04lX)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


