// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_data_width.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_data_width
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI20C500K_IOCTL_DATA_WIDTH service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi20c500k_data_width(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Data Width", index);

	ret		= dsi20c500k_ioctl(fd, DSI20C500K_IOCTL_DATA_WIDTH, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case DSI20C500K_DATA_WIDTH_16:

			ptr	= "16-bits";
			break;

		case DSI20C500K_DATA_WIDTH_18:

			ptr	= "18-bits";
			break;

		case DSI20C500K_DATA_WIDTH_20:

			ptr	= "20-bits";
			break;

		case DSI20C500K_DATA_WIDTH_24:

			ptr	= "24-bits";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


