// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_count.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_count_boards
*
*	Purpose:
*
*		Count the number of installed devices.
*
*	Arguments:
*
*		verbose	Work verbosely?
*
*		qty		The count is returned here.
*
*	Returned:
*
*		>= 0	The number of errors found.
*
******************************************************************************/

int dsi20c500k_count_boards(int verbose, s32* qty)
{
	int	errs;

	errs	= os_count_boards(verbose, qty, dsi20c500k_open, dsi20c500k_read, dsi20c500k_close);
	return(errs);
}



