// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_config_ai.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_config_ai
*
*	Purpose:
*
*		Configure the given device using common defaults.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		fref	This is the PLL Fref value, or -1 to use the default.
*
*		fsamp	This is the desired Fsamp rate, of -1 to use the default.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	dsi20c500k_config_ai(int fd, int index, int verbose, s32 fref, s32 fsamp)
{
	int	errs	= 0;
	s32	ndiv;
	s32	nref;
	s32	nvco;
	s32	osr;

	if (verbose)
	{
		gsc_label_index("Input Configuration", index);
		printf("\n");
		gsc_label_level_inc();
	}

	errs	+= dsi20c500k_initialize				(fd, index, verbose);

	// Settings must be applied after the initialization call!

	errs	+= dsi20c500k_rx_io_mode				(fd, index, verbose, GSC_IO_MODE_BMDMA,					NULL);
	errs	+= dsi20c500k_rx_io_overflow			(fd, index, verbose, DSI20C500K_IO_OVERFLOW_CHECK,		NULL);
	errs	+= dsi20c500k_rx_io_timeout				(fd, index, verbose, 30,								NULL);
	errs	+= dsi20c500k_rx_io_underflow			(fd, index, verbose, DSI20C500K_IO_UNDERFLOW_CHECK,		NULL);
	errs	+= dsi20c500k_ai_mode					(fd, index, verbose, DSI20C500K_AI_MODE_DIFF,			NULL);
	errs	+= dsi20c500k_ai_buf_thresh				(fd, index, verbose, 128L * 1024,						NULL);
	errs	+= dsi20c500k_ai_channel_tag			(fd, index, verbose, DSI20C500K_AI_CHANNEL_TAG_ENABLE,	NULL);
	errs	+= dsi20c500k_sw_sync_mode				(fd, index, verbose, DSI20C500K_SW_SYNC_MODE_CLR_BUF,	NULL);
	errs	+= dsi20c500k_data_format				(fd, index, verbose, DSI20C500K_DATA_FORMAT_OFF_BIN,	NULL);
	errs	+= dsi20c500k_data_width				(fd, index, verbose, DSI20C500K_DATA_WIDTH_16,			NULL);
	errs	+= dsi20c500k_dio_dir_out				(fd, index, verbose, 0x0,								NULL);
	errs	+= dsi20c500k_control_mode				(fd, index, verbose, DSI20C500K_CONTROL_MODE_INITIATOR,	NULL);
	errs	+= dsi20c500k_ext_clk_src				(fd, index, verbose, DSI20C500K_EXT_CLK_SRC_GRP_0,		NULL);
	errs	+= dsi20c500k_query						(fd, index, verbose, DSI20C500K_QUERY_FREF_DEFAULT,		&fref);
	errs	+= dsi20c500k_ch_grp_0_src				(fd, index, verbose, DSI20C500K_CH_GRP_SRC_RATE_GEN,	NULL);
	errs	+= dsi20c500k_ch_grp_1_src				(fd, index, verbose, DSI20C500K_CH_GRP_SRC_RATE_GEN,	NULL);
	errs	+= dsi20c500k_fsamp_ai_compute			(fd, index, verbose, fref, fsamp, &nvco, &nref, &ndiv, &osr, NULL);
	errs	+= dsi20c500k_nvco						(fd, index, verbose, nvco,								NULL);
	errs	+= dsi20c500k_nref						(fd, index, verbose, nref,								NULL);
	errs	+= dsi20c500k_ndiv						(fd, index, verbose, ndiv,								NULL);
	errs	+= dsi20c500k_osr						(fd, index, verbose, osr,								NULL);
	errs	+= dsi20c500k_xcvr_type					(fd, index, verbose, DSI20C500K_XCVR_TYPE_LVDS,			NULL);
	errs	+= dsi20c500k_burst						(fd, index, verbose, DSI20C500K_BURST_DISABLE,			NULL);
	errs	+= dsi20c500k_burst_rate_div			(fd, index, verbose, 1,									NULL);
	errs	+= dsi20c500k_burst_size				(fd, index, verbose, 1,									NULL);
	errs	+= dsi20c500k_burst_timer				(fd, index, verbose, DSI20C500K_BURST_TIMER_DISABLE,	NULL);
	errs	+= dsi20c500k_ai_buf_enable				(fd, index, verbose, DSI20C500K_AI_BUF_ENABLE_YES,		NULL);

	errs	+= dsi20c500k_fsamp_ai_report_all		(fd, index, verbose,									NULL);

	// Settings affecting the sample rate or voltage range must generally
	// be applied before autocalibration.
	// Refer to the device user manual for clarification.
//	errs	+= dsi20c500k_autocal					(fd, index, verbose);	// Cable may need disconnecting for this.

	// Interrupt selections should be applied after autocalibration as the
	// driver overwrites the current selection to detect the Autocalibration
	// Done interrupt. If an application intends to detect the Autocalibration
	// Done interrupt, then the interrupt selection may be made beforehand.
	errs	+= dsi20c500k_irq_sel					(fd, index, verbose, DSI20C500K_IRQ_INIT_DONE,			NULL);

	// The final step is to clear the buffer. This service clears the FIFO and
	// resets the overflow and underflow status bits.
	errs	+= dsi20c500k_ai_buf_clear				(fd, index, verbose, 1);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


