// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_channel_group.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_channel_group
*
*	Purpose:
*
*		Report the channel group for the specified channel.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		chan	The channel index.
*
*		group	The channel's group index.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi20c500k_channel_group(int fd, int index, int verbose, s32 chan, s32* group)
{
	s32	chans;
	int	errs;

	group[0]	= 0;
	errs		= dsi20c500k_query(fd, -1, 0, DSI20C500K_QUERY_CHANNEL_QTY, &chans);

	if (errs)
	{
	}
	else if (chan < 0)
	{
		errs++;

		if (verbose)
		{
			printf(	"FAIL <---  (%d. invalid channel index: %ld, min is %ld)\n",
					__LINE__,
					(long) chan,
					(long) 0);
		}
	}
	else if (chan >= chans)
	{
		errs++;

		if (verbose)
		{
			printf(	"FAIL <---  (%d. invalid channel index: %ld, max is %ld)\n",
					__LINE__,
					(long) chan,
					(long) chans - 1);
		}
	}
	else
	{
		switch (chans)
		{
			default:

				errs++;

				if (verbose)
				{
					printf(	"FAIL <---  (%d. unexpected channel count: %ld)\n",
							__LINE__,
							(long) chans);
				}

				break;

			case 4:		group[0]	= (chan <= 1) ? 0 : 1;	break;
			case 8:		group[0]	= (chan <= 3) ? 0 : 1;	break;
			case 12:	group[0]	= (chan <= 5) ? 0 : 1;	break;
			case 20:	group[0]	= (chan <= 9) ? 0 : 1;	break;
		}
	}

	return(errs);
}


