// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_ai_buf_thr_sts.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_ai_buf_thr_sts
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI20C500K_IOCTL_AI_BUF_THR_STS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi20c500k_ai_buf_thr_sts(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;
	s32			set;

	if (verbose)
		gsc_label_index("AI Buffer Threshold Status", index);

	ret		= dsi20c500k_ioctl(fd, DSI20C500K_IOCTL_AI_BUF_THR_STS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case DSI20C500K_AI_BUF_THR_STS_IDLE:

			ptr	= "Idle";
			break;

		case DSI20C500K_AI_BUF_THR_STS_ACTIVE:

			ptr	= "Active";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


