// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/util_ai_buf_clear.c $
// $Rev: 53471 $
// $Date: 2023-07-26 15:49:04 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_ai_buf_clear
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI20C500K_IOCTL_AI_BUF_CLEAR service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		at_bndy	Clear the buffer at a scan boundary?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi20c500k_ai_buf_clear(int fd, int index, int verbose, int at_bndy)
{
	int	errs	= 0;
	s32	mode;
	int	ret;

	if (verbose)
		gsc_label_index("AI Buffer Clear", index);

	if (at_bndy)
	{
		errs	+= dsi20c500k_sw_sync_mode	(fd, -1, 0, -1, &mode);

		// Clear the buffer with any over or under flow status.
		ret		= dsi20c500k_ioctl(fd, DSI20C500K_IOCTL_AI_BUF_CLEAR, NULL);
		errs	+= ret ? 1 : 0;

		// Clear the buffer on a scan boundary.
		errs	+= dsi20c500k_sw_sync_mode	(fd, -1, 0, DSI20C500K_SW_SYNC_MODE_SYNC, NULL);
		errs	+= dsi20c500k_sw_sync		(fd, -1, 0);
		errs	+= dsi20c500k_channels_ready(fd, -1, 0, DSI20C500K_CHANNELS_READY_WAIT, NULL);

		errs	+= dsi20c500k_sw_sync_mode	(fd, -1, 0, DSI20C500K_SW_SYNC_MODE_CLR_BUF, NULL);
		errs	+= dsi20c500k_sw_sync		(fd, -1, 0);
		errs	+= dsi20c500k_channels_ready(fd, -1, 0, DSI20C500K_CHANNELS_READY_WAIT, NULL);

		// Restore the SW Sync Mode.
		errs	+= dsi20c500k_sw_sync_mode	(fd, -1, 0, mode, NULL);
	}
	else
	{
		ret		= dsi20c500k_ioctl(fd, DSI20C500K_IOCTL_AI_BUF_CLEAR, NULL);
		errs	+= ret ? 1 : 0;
	}

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


