// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/utils/close.c $
// $Rev: 46056 $
// $Date: 2019-08-13 15:31:50 -0500 (Tue, 13 Aug 2019) $

// 24DSI20C500K: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi20c500k_close_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device close call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi20c500k_close_util(int fd, int index, int verbose)
{
	int	errs	= 0;
	int	ret;

	if (verbose)
		gsc_label_index("Close", index);

	ret		= dsi20c500k_close(fd);
	errs	+= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


