// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/samples/sw_sync/perform.c $
// $Rev: 53469 $
// $Date: 2023-07-26 15:44:20 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	time_t	end;
	int		errs	= 0;
	time_t	now;
	int		ret;

	errs	+= dsi20c500k_initialize		(args->fd, -1, 1);
	errs	+= dsi20c500k_control_mode		(args->fd, -1, 1, DSI20C500K_CONTROL_MODE_INITIATOR, NULL);
	errs	+= dsi20c500k_xcvr_type			(args->fd, -1, 1, DSI20C500K_XCVR_TYPE_TTL, NULL);

	gsc_label("Working");
	printf("%d seconds ... ", args->seconds);
	fflush(stdout);
	end	= time(NULL) + args->seconds;

	for (; errs == 0;)
	{
		ret		= dsi20c500k_ioctl(args->fd, DSI20C500K_IOCTL_SW_SYNC, NULL);
		errs	= ret ? 1 : 0;
		now		= time(NULL);

		if (now > end)
			break;

		os_sleep_ms(2);
	}

	printf("Done\n");
	return(errs);
}



