// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/samples/signals/perform.c $
// $Rev: 53468 $
// $Date: 2023-07-26 15:43:57 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	char	buf[80];
	time_t	end;
	int		errs	= 0;
	s32		fref;
	time_t	now;
	int		test;

	//===============================================================
	gsc_label("Setup");
	printf("\n");
	gsc_label_level_inc();

	errs	+= dsi20c500k_initialize		(args->fd, -1, 1);
	errs	+= dsi20c500k_control_mode		(args->fd, -1, 1, DSI20C500K_CONTROL_MODE_INITIATOR, NULL);
	errs	+= dsi20c500k_xcvr_type			(args->fd, -1, 1, DSI20C500K_XCVR_TYPE_TTL, NULL);

	gsc_label_level_dec();

	//===============================================================
	gsc_label("Clock Output");
	printf("\n");
	gsc_label_level_inc();

	errs	+= dsi20c500k_query				(args->fd, -1, 1, DSI20C500K_QUERY_FREF_DEFAULT, &fref);
	errs	+= dsi20c500k_nvco				(args->fd, -1, 1, 25, NULL);
	errs	+= dsi20c500k_nref				(args->fd, -1, 1, 40, NULL);
	errs	+= dsi20c500k_ndiv				(args->fd, -1, 1, 2, NULL);
	errs	+= dsi20c500k_osr				(args->fd, -1, 1, DSI20C500K_OSR_256, NULL);
	errs	+= dsi20c500k_ch_grp_0_src		(args->fd, -1, 1, DSI20C500K_CH_GRP_SRC_RATE_GEN, NULL);
	errs	+= dsi20c500k_ext_clk_src		(args->fd, -1, 1, DSI20C500K_EXT_CLK_SRC_GRP_0, NULL);

	gsc_label_level_dec();

	//===============================================================
	gsc_label("Sync Output");
	printf("\n");
	gsc_label_level_inc();

	errs	+= dsi20c500k_burst_size		(args->fd, -1, 1, 1, NULL);
	errs	+= dsi20c500k_burst_rate_div	(args->fd, -1, 1, 10000, NULL);
	errs	+= dsi20c500k_burst_timer		(args->fd, -1, 1, DSI20C500K_BURST_TIMER_ENABLE, NULL);

	gsc_label_level_dec();

	//===============================================================
	sprintf(buf, "Working (%ld sec%s)", (long) args->seconds, (args->seconds == 1) ? "" : "s");
	gsc_label(buf);
	fflush(stdout);
	end	= time(NULL) + args->seconds;

	for (; errs == 0;)
	{
		test	= dsi20c500k_ioctl(args->fd, DSI20C500K_IOCTL_SW_SYNC, NULL);
		errs	+= (test == -1) ? 1 : 0;
		now		= time(NULL);

		if (now > end)
			break;

		os_sleep_ms(1);
	}

	printf("Done\n");

	errs	+= dsi20c500k_initialize(args->fd, -1, 1);

	return(errs);
}



