// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/samples/led/perform.c $
// $Rev: 53464 $
// $Date: 2023-07-26 15:42:43 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("LED Flashing");
	printf("\n");
	errs	+= dsi20c500k_initialize(args->fd, -1, 1);
	gsc_label_level_inc();

	for (i = 1; i <= 16; i++)
	{
		// Turn the LED on.
		errs	+= dsi20c500k_led(args->fd, -1, 1, DSI20C500K_LED_ON, NULL);
		os_sleep_ms(100);

		// Turn the LED off.
		errs	+= dsi20c500k_led(args->fd, -1, 1, DSI20C500K_LED_OFF, NULL);
		os_sleep_ms(100);
	}

	gsc_label_level_dec();
	errs	+= dsi20c500k_initialize(args->fd, -1, 1);
	return(errs);
}


