// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/samples/id/perform.c $
// $Rev: 53463 $
// $Date: 2023-07-26 15:42:27 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _input_modes(void)
{
	gsc_label("Input Modes");
	printf("Differential, Zero Test, +Vref Test\n");
}



//*****************************************************************************
static int _id_device_reg(const args_t* args)
{
	int						errs;
	gsc_reg_def_t			list[2]	= { { NULL }, { NULL } };
	const gsc_reg_def_t*	ptr;

	printf("\n");
	ptr	= dsi20c500k_reg_get_def_id(DSI20C500K_GSC_BCFGR);

	if (ptr)
	{
		list[0]	= ptr[0];
		errs	= gsc_reg_list(args->fd, list, 1, dsi20c500k_reg_read);
	}
	else
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. dsi20c500k_reg_get_def_id, DSI20C500K_GSC_BCFGR)\n",
				__LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _register_map(const args_t* args)
{
	int	errs;

	printf("\n");
	errs	= dsi20c500k_reg_list(args->fd, args->detail);
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("Device Features");
	printf("\n");

	gsc_label_level_inc();

	_input_modes();

	for (i = 0; i < DSI20C500K_QUERY_LAST; i++)
		errs	+= dsi20c500k_query(args->fd, -1, 1, i, NULL);

	gsc_label_level_dec();

	errs	+= _id_device_reg(args);
	errs	+= _register_map(args);
	printf("\n");

	return(errs);
}


