// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/samples/fsamp/perform.c $
// $Rev: 53462 $
// $Date: 2023-07-26 15:42:08 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	FILE_NAME				"fsamp.txt"
#define	LIMIT_MAX(v,max)		(((v) > (max)) ? (max) : (v))
#define	LIMIT_MIN(v,min)		(((v) < (min)) ? (min) : (v))
#define	LIMIT_RANGE(v,min,max)	(LIMIT_MIN((LIMIT_MAX((v),(max))),(min)))



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	FILE*	file	= NULL;
	s32		fref;
	s32		fsamp;
	s32		max		= args->fsamp;
	s32		min		= args->fsamp;
	double	rate;

	gsc_label("Fsamp Computation");
	printf("\n");
	gsc_label_level_inc();

	errs	+= dsi20c500k_query(args->fd, -1, 1, DSI20C500K_QUERY_FREF_DEFAULT, &fref);
	errs	+= dsi20c500k_query(args->fd, -1, 1, DSI20C500K_QUERY_FSAMP_MAX, &max);
	errs	+= dsi20c500k_query(args->fd, -1, 1, DSI20C500K_QUERY_FSAMP_MIN, &min);

	if (args->range == 0)
	{
		min	= LIMIT_RANGE(args->fsamp, min, max);
		max	= min;
	}

	if (args->save)
	{
		file	= fopen(FILE_NAME, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", FILE_NAME);
			errs	= 1;
		}
		else
		{
			fprintf(file, "# 24DSI20C500K Scan Rates\n");
			fprintf(file, "# Request  Produced\n");
			fprintf(file, "# =======  ==========\n");
		}
	}

	for (fsamp = min; fsamp <= max; fsamp++)
	{
		errs	+= dsi20c500k_fsamp_ai_compute(args->fd, -1, 1, fref, fsamp, NULL, NULL, NULL, NULL, &rate);

		if (file)
			fprintf(file, "%9ld  %10.3f\n", (long) fsamp, (float) rate);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}


